package com.biz.crm.position.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.position.req.MdmPositionCustomerOrgPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionCustomerOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionCustomerOrgUpdateReqVo;
import com.biz.crm.position.service.MdmPositionCustomerOrgService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 职位与客户组织
 *
 * @author zxw
 * @date 2020-11-03 17:31:28
 */
@Slf4j
@RestController
@RequestMapping("/mdmPositionCustomerOrgController")
@Api(tags = "客户组织-关联职位")
@CrmGlobalLog
public class MdmPositionCustomerOrgController {
    @Resource
    private MdmPositionCustomerOrgService mdmPositionCustomerOrgService;

    @ApiOperation("未关联职位分页")
    @PostMapping("/unRelationPage")
    public Result<PageResult<MdmPositionCustomerOrgRespVo>> unRelationPage(@RequestBody MdmPositionCustomerOrgPageReqVo mdmPositionCustomerOrgPageReqVo) {
        return Result.ok(mdmPositionCustomerOrgService.unRelationPage(mdmPositionCustomerOrgPageReqVo));
    }

    @ApiOperation("已关联职位列表")
    @PostMapping("/relationList")
    public Result<List<MdmPositionCustomerOrgRespVo>> relationList(@RequestBody MdmPositionCustomerOrgPageReqVo mdmPositionCustomerOrgPageReqVo) {
        return Result.ok(mdmPositionCustomerOrgService.relationList(mdmPositionCustomerOrgPageReqVo));
    }

    @ApiOperation("添加")
    @PostMapping("/add")
    public Result<Object> add(@RequestBody MdmPositionCustomerOrgUpdateReqVo mdmPositionCustomerOrgUpdateReqVo) {
        mdmPositionCustomerOrgService.add(mdmPositionCustomerOrgUpdateReqVo);
        return Result.ok();
    }

    @ApiOperation("删除")
    @PostMapping("/remove")
    public Result<Object> remove(@RequestBody MdmPositionCustomerOrgUpdateReqVo mdmPositionCustomerOrgUpdateReqVo) {
        mdmPositionCustomerOrgService.remove(mdmPositionCustomerOrgUpdateReqVo);
        return Result.ok();
    }


}
