package com.biz.crm.position.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUnderlingParentSelectReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUnderlingReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUnderlingRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgPageRespVo;
import com.biz.crm.position.service.MdmPositionUnderlingService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 职位管理-下属
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Slf4j
@RestController
@RequestMapping("/mdmPositionUnderlingController")
@Api(tags = "MDM-职位管理-下属")
@CrmGlobalLog
public class MdmPositionUnderlingController {

    @Autowired
    private MdmPositionUnderlingService mdmPositionUnderlingService;

    @ApiOperation(value = "查询下属列表（分页）", notes = "positionCode必传")
    @PostMapping("/findPositionUnderlingList")
    public Result<PageResult<MdmPositionUnderlingRespVo>> findPositionUnderlingList(@RequestBody MdmPositionUnderlingReqVo reqVo) {
        PageResult<MdmPositionUnderlingRespVo> result = mdmPositionUnderlingService.findPositionUnderlingList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "下属-关联上级职位", notes = "传（underlingPositionCodeList、positionCode）")
    @PostMapping("/replaceParentPosition")
    public Result replaceParentPosition(@RequestBody MdmPositionUnderlingReqVo reqVo) {
        mdmPositionUnderlingService.replaceParentPosition(reqVo);
        return Result.ok();
    }

    @ApiOperation(value = "查询下属选择上级职位选择列表", notes = "excludeChildPositionCodeList必填，值为下级职位集合")
    @PostMapping("/findParentPositionList")
    public Result<PageResult<MdmPositionUserOrgPageRespVo>> findPositionUnderlingParentSelectPageList(@RequestBody MdmPositionUnderlingParentSelectReqVo reqVo) {
        return Result.ok(mdmPositionUnderlingService.findPositionUnderlingParentSelectPageList(reqVo));
    }


}
