package com.biz.crm.position.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleRelationPositionPageReqVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRelationPositionPageRespVo;
import com.biz.crm.position.model.MdmPositionBpmRoleEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 职位与流程角色关联
 *
 * @author Tao.Chen
 * @date 2020-11-26 20:07:10
 */
public interface MdmPositionBpmRoleMapper extends BaseMapper<MdmPositionBpmRoleEntity> {

    /**
     * 查询未关联任何流程角色的职位
     *
     * @param page
     * @param mdmBpmRoleRelationPositionPageReqVo
     * @return
     */
    @SqlPrivilege(posCode = "a1.position_code")
    List<MdmBpmRoleRelationPositionPageRespVo> findPositionNotRelateAnyBpmRoleList(Page<MdmBpmRoleRelationPositionPageRespVo> page, @Param("vo") MdmBpmRoleRelationPositionPageReqVo mdmBpmRoleRelationPositionPageReqVo);

    /**
     * 查询未关联指定流程角色的职位
     *
     * @param page
     * @param mdmBpmRoleRelationPositionPageReqVo
     * @return
     */
    @SqlPrivilege(posCode = "a1.position_code")
    List<MdmBpmRoleRelationPositionPageRespVo> findPositionNotRelateCurBpmRoleList(Page<MdmBpmRoleRelationPositionPageRespVo> page, @Param("vo") MdmBpmRoleRelationPositionPageReqVo mdmBpmRoleRelationPositionPageReqVo);

    /**
     * 查询已关联指定流程角色的职位
     *
     * @param page
     * @param mdmBpmRoleRelationPositionPageReqVo
     * @return
     */
    @SqlPrivilege(posCode = "a1.position_code")
    List<MdmBpmRoleRelationPositionPageRespVo> findPositionHasRelateCurBpmRoleList(Page<MdmBpmRoleRelationPositionPageRespVo> page, @Param("vo") MdmBpmRoleRelationPositionPageReqVo mdmBpmRoleRelationPositionPageReqVo);

}
