package com.biz.crm.position.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.position.req.MdmPositionCustomerOrgPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionCustomerOrgRespVo;
import com.biz.crm.position.model.MdmPositionCustomerOrgEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * 职位与用户关联表
 *
 * @author zxw
 * @date 2020-11-03 17:31:28
 */
public interface MdmPositionCustomerOrgMapper extends BaseMapper<MdmPositionCustomerOrgEntity> {

    @SqlPrivilege(posCode = "c.position_code",orgCode = "c.org_code")
    List<MdmPositionCustomerOrgRespVo> relationList(@Param("vo") MdmPositionCustomerOrgPageReqVo mdmPositionCustomerOrgPageReqVo);

    @SqlPrivilege(posCode = "c.position_code",orgCode = "c.org_code")
    List<MdmPositionCustomerOrgRespVo> unRelationPage(Page page, @Param("vo") MdmPositionCustomerOrgPageReqVo mdmPositionCustomerOrgPageReqVo);

    @SqlPrivilege(posCode = "c.position_code",orgCode = "c.org_code")
    List<String> findRelationPosition(@Param("customerOrgCode") String customerOrgCode);
}
