package com.biz.crm.position.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRelationCustomerPageRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface MdmPositionRelationCustomerMapper {

    /**
     * 查询未关联任何用户的客户
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmPositionRelationCustomerPageRespVo> findCustomerNotRelateAnyPosition(Page<MdmPositionRelationCustomerPageRespVo> page, @Param("vo") MdmPositionRelationCustomerPageReqVo reqVo);

    /**
     * 查询未关联当前用户的客户
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmPositionRelationCustomerPageRespVo> findCustomerNotRelateCurPosition(Page<MdmPositionRelationCustomerPageRespVo> page, @Param("vo") MdmPositionRelationCustomerPageReqVo reqVo);

    /**
     * 查询已关联当前用户的客户
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmPositionRelationCustomerPageRespVo> findCustomerHasRelateCurPosition(Page<MdmPositionRelationCustomerPageRespVo> page, @Param("vo") MdmPositionRelationCustomerPageReqVo reqVo);

}
