package com.biz.crm.position.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.Map;

/**
 * @Author hej
 * @Created Date 2021-01-07 14:27
 **/
public class MdmPositionProvider {

    public String findListProvider(Map<String,Object> map){
        MdmPositionPageReqVo vo = (MdmPositionPageReqVo) map.get("vo");
        return new SQL(){{
            SELECT("c10.*");
            FROM("("+findListFirstSon(vo)+") c10");
            if(StringUtils.isNotEmpty(vo.getUserName())){
                WHERE("c10.user_name like "+ProviderUtil.bindPercent(vo.getUserName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getUserCode())){
                WHERE("c10.user_code like "+ProviderUtil.bindPercent(vo.getUserCode(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getParentName())){
                WHERE("c10.parent_name "+ProviderUtil.bindPercent(vo.getParentName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getFullName())){
                WHERE("c10.full_name like "+ProviderUtil.bindPercent(vo.getFullName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getOrgName())){
                WHERE("c10.org_name like "+ProviderUtil.bindPercent(vo.getOrgName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getParentOrgName())){
                WHERE(" c10.parent_org_name like "+ProviderUtil.bindPercent(vo.getParentOrgName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getPositionLevelName())){
                WHERE("c10.position_level_name like"+ProviderUtil.bindPercent(vo.getPositionLevelName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            ORDER_BY(" c10.position_code desc");

        }}.toString();
    }

    private String findListFirstSon(MdmPositionPageReqVo vo){
        return new SQL(){{
            SELECT(" b10.*," +
                    "        b10.role_code_redundancy as role_code," +
                    "        b10.role_name_redundancy as role_name," +
                    "        b20.org_name," +
                    "        b30.position_level_name," +
                    "        b40.position_name as parent_name," +
                    "        b41.org_code as parent_org_code," +
                    "        b41.org_name as parent_org_name," +
                    "        b60.user_name," +
                    "        b60.full_name," +
                    "        b60.user_code," +
                    "        b60.user_head_url," +
                    "        b80.user_code as parent_user_code," +
                    "        b80.user_name as parent_user_name," +
                    "        b80.full_name as parent_full_name");
            FROM("("+findListSecondSon(vo)+") b10");
            LEFT_OUTER_JOIN("mdm_org b20 on b10.org_code = b20.org_code");
            LEFT_OUTER_JOIN("mdm_position_level b30 on b10.position_level_code = b30.position_level_code");
            LEFT_OUTER_JOIN("mdm_position b40 on b10.parent_code = b40.position_code");
            LEFT_OUTER_JOIN("mdm_org b41 on b40.org_code = b41.org_code");
            LEFT_OUTER_JOIN("mdm_position_user b50 on b10.position_code = b50.position_code");
            LEFT_OUTER_JOIN("mdm_user b60 on b50.user_name = b60.user_name");
            LEFT_OUTER_JOIN("mdm_position_user b70 on b40.position_code = b70.position_code");
            LEFT_OUTER_JOIN("mdm_user b80 on b70.user_name = b80.user_name");
            WHERE("b10.del_flag = '009'");
            if(StringUtils.isNotEmpty(vo.getRoleCode())){
                WHERE("b20.rule_code like "+ ProviderUtil.bindPercent(vo.getRoleCode(), MdmProviderEnum.SQL_JOIN_RIGHT));
            }
        }
        }.toString();
    }

    private String findListSecondSon(MdmPositionPageReqVo vo){
        //TODO 测试
//        List<MdmColumnConfigRespVo> cvo = ProviderUtil.getTestList();
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){{
            SELECT("*");
            FROM("mdm_position");
            WHERE("del_flag = '009'");
            if(StringUtils.isNotEmpty(vo.getPrimaryFlag())){
                WHERE("primary_flag = #{vo.primaryFlag}");
            }
            if(StringUtils.isNotEmpty(vo.getEnableStatus())){
                WHERE("enable_status = #{vo.enableStatus}");
            }
            if(StringUtils.isNotEmpty(vo.getPositionLevelCode())){
                WHERE("position_level_code = #{vo.positionLevelCode}");
            }
            if(StringUtils.isNotEmpty(vo.getOrgCode())){
                WHERE("org_code = #{vo.orgCode}");
            }
            if(StringUtils.isNotEmpty(vo.getRuleCode())){
                WHERE("position_code in (select distinct t2.position_code from mdm_role t1 left join mdm_position_role t2" +
                        "        on t1.role_code = t2.role_code where t1.role_code = #{vo.roleCode})");
            }
            if(StringUtils.isNotEmpty(vo.getRoleName())){
                WHERE("position_code in (select distinct t2.position_code from mdm_role t1 left join mdm_position_role t2" +
                        "        on t1.role_code = t2.role_code where t1.role_name like "+
                        ProviderUtil.bindPercent(vo.getRoleName(),MdmProviderEnum.SQL_JOIN_ALL)+")");
            }
            if(StringUtils.isNotEmpty(vo.getPositionCode())){
                WHERE("position_code like "+ProviderUtil.bindPercent(vo.getPositionCode(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getPositionName())){
                WHERE("position_name like "+ProviderUtil.bindPercent(vo.getPositionName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, ""));
            }
        }}.toString();
    }

}


