package com.biz.crm.position.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleRelationPositionPageReqVo;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleRelationPositionReqVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRelationPositionPageRespVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.position.model.MdmPositionBpmRoleEntity;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 职位与流程角色关联接口
 *
 * @author Tao.Chen
 * @date 2020-11-26 20:07:10
 */
public interface MdmPositionBpmRoleService extends IService<MdmPositionBpmRoleEntity> {

    /**
     * 添加职位与流程角色的关联关系
     *
     * @param positionCode 职位编码
     * @param bpmRoleCode  流程角色编码
     */
    void addPositionBpmRole(String positionCode, String bpmRoleCode);

    /**
     * 添加职位与流程角色的关联关系
     *
     * @param positionCode    职位编码
     * @param bpmRoleCodeList 流程角色编码集合
     */
    void addPositionBpmRole(String positionCode, List<String> bpmRoleCodeList);

    /**
     * 添加职位与流程角色的关联关系
     *
     * @param positionCodeList 职位编码集合
     * @param bpmRoleCode      流程角色编码
     */
    void addPositionBpmRole(List<String> positionCodeList, String bpmRoleCode);

    /**
     * 移除职位与任何流程角色的关联关系
     *
     * @param positionCode 职位编码
     */
    void removeByPosition(String positionCode);

    /**
     * 批量移除职位与任何流程角色的关联关闭西
     *
     * @param positionCodeList 职位编码集合
     */
    void removeByPositions(List<String> positionCodeList);

    /**
     * 移除流程角色与任何职位的关联关系
     *
     * @param bpmRoleCode 流程角色编码
     */
    void removeByBpmRole(String bpmRoleCode);

    /**
     * 批量移除流程角色与任何职位的关联关系
     *
     * @param bpmRoleCodeList 流程角色编码集合
     */
    void removeByBpmRoles(List<String> bpmRoleCodeList);

    /**
     * 移除指定职位、流程角色的关联关系
     *
     * @param positionCode 职位编码
     * @param bpmRoleCode  流程角色编码
     */
    void removeByPositionBpmRole(String positionCode, String bpmRoleCode);

    /**
     * 移除指定职位、流程角色的关联关系
     *
     * @param positionCode    职位编码
     * @param bpmRoleCodeList 流程角色编码集合
     */
    void removeByPositionBpmRole(String positionCode, List<String> bpmRoleCodeList);

    /**
     * 移除指定职位、流程角色的关联关系
     *
     * @param positionCodeList 职位编码集合
     * @param bpmRoleCode      流程角色编码
     */
    void removeByPositionBpmRole(List<String> positionCodeList, String bpmRoleCode);

    /**
     * 根据职位编码集合查询关联的流程角色编码集合
     *
     * @param positionCodeList
     * @return
     */
    Set<String> findBpmRoleCodeSetByPositionCodeList(List<String> positionCodeList);

    /**
     * 根据职位编码获取职位关联的流程角色
     *
     * @param positionCode 职位编码
     * @return
     */
    List<MdmBpmRoleRespVo> getPositionBpmRoleList(String positionCode);

    /**
     * 查询职位关联的流程角色编码,分组返回
     *
     * @param positionCodeList 职位编码集合
     * @return
     */
    Map<String, List<String>> getPositionBpmRoleCodeGroupByPositionCodeList(List<String> positionCodeList);

    /**
     * 查询职位关联的流程角色,分组返回
     *
     * @param positionCodeList 职位编码集合
     * @return
     */
    Map<String, List<MdmBpmRoleRespVo>> getPositionBpmRoleGroupByPositionCodeList(List<String> positionCodeList);

    /**
     * 查询未关联任何流程角色的职位
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmBpmRoleRelationPositionPageRespVo> findPositionNotRelateAnyBpmRoleList(MdmBpmRoleRelationPositionPageReqVo reqVo);

    /**
     * 查询未关联指定流程角色的职位
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmBpmRoleRelationPositionPageRespVo> findPositionNotRelateCurBpmRoleList(MdmBpmRoleRelationPositionPageReqVo reqVo);

    /**
     * 查询已关联指定流程角色的职位
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmBpmRoleRelationPositionPageRespVo> findPositionHasRelateCurBpmRoleList(MdmBpmRoleRelationPositionPageReqVo reqVo);

    /**
     * 通过职位编码集合和流程角色编码添加关联关系
     *
     * @param reqVo
     */
    void positionRelationBpmRole(MdmBpmRoleRelationPositionReqVo reqVo);

    /**
     * 通过关联表ids和流程角色编码替换职位关联的流程角色
     *
     * @param reqVo
     */
    void replaceBindBpmRole(MdmBpmRoleRelationPositionReqVo reqVo);

}

