package com.biz.crm.position.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.position.model.MdmPositionUserEntity;

import java.util.List;
import java.util.Map;

/**
 * 职位-用户关联表接口
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
public interface MdmPositionUserService extends IService<MdmPositionUserEntity> {

    /**
     * 添加用户和职位关联关系
     *
     * @param userName     用户登录名
     * @param positionCode 职位编码
     */
    void addUserPosition(String userName, String positionCode);

    void addUserPosition(String userName, String positionCode, String primaryFlag);

    void changeUserPrimaryPosition(String userName, String primaryPositionCode);

    void changeUserCurrentPosition(String userName, String currentPositionCode);

    /**
     * 添加用户和职位关联关系
     *
     * @param userName         用户登录名
     * @param positionCodeList 职位编码集合
     */
    void addUserPosition(String userName, List<String> positionCodeList);

    /**
     * 重新设置用户的职位
     *
     * @param userName            用户登录名，必填
     * @param primaryPositionCode 主职位编码，必填
     * @param positionCodeList    其它职位编码集合，非必填（包不包含主职位编码无所谓）
     */
    void resetUserPosition(String userName, String primaryPositionCode, List<String> positionCodeList);

    /**
     * 移除职位与任何用户的关联关系
     *
     * @param positionCode 职位编码
     */
    void removeByPositionCode(String positionCode);

    /**
     * 批量移除职位与任何用户的关联关系
     *
     * @param positionCodeList 职位编码集合
     */
    void removeByPositionCodes(List<String> positionCodeList);

    /**
     * 移除用户与任何职位的关联关系
     *
     * @param userName 用户登录名
     */
    void removeByUserName(String userName);

    /**
     * 批量移除用户与任何职位的关联关系
     *
     * @param userNameList 用户登录名集合
     */
    void removeByUserNames(List<String> userNameList);

    /**
     * 获取用户关联的职位编码
     *
     * @param userName 用户登录名
     * @return
     */
    List<String> getPositionCodeListByUserName(String userName);

    /**
     * 获取用户关联的职位编码，结果去重后合并返回
     *
     * @param userNameList 用户登录名集合
     * @return
     */
    List<String> getPositionCodeListByUserNameList(List<String> userNameList);

    /**
     * 根据用户登录名获取用户关联的职位编码，结果按照用户名分组
     *
     * @param userNameList 用户登录名集合
     * @return
     */
    Map<String, List<String>> getPositionCodeListGroupByUserNameList(List<String> userNameList);

    /**
     * 获取职位对应的用户登录名
     *
     * @param positionCode 职位编码
     * @return
     */
    String getUserNameByPositionCode(String positionCode);

    String getUserNameByPrimaryPositionCode(String positionCode);

    String getPrimaryPositionCodeByUserName(String userName);

    /**
     * 获取职位编码对应的用户，结果去重后合并返回
     *
     * @param positionCodeList 职位编码集合
     * @return
     */
    List<String> getUserNameListByPositionCodeList(List<String> positionCodeList);

    /**
     * 根据职位编码集合获取职位关联的用户登录名
     *
     * @param positionCodeList 职位编码集合
     * @return
     */
    Map<String, String> getUserNameGroupByPositionCodeList(List<String> positionCodeList);

}

