package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.position.req.MdmPositionCustomerOrgPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionCustomerOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionCustomerOrgUpdateReqVo;
import com.biz.crm.position.mapper.MdmPositionCustomerOrgMapper;
import com.biz.crm.position.model.MdmPositionCustomerOrgEntity;
import com.biz.crm.position.service.MdmPositionCustomerOrgService;
import com.biz.crm.util.PageUtil;
import io.jsonwebtoken.lang.Assert;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 职位与用户关联表接口实现
 *
 * @author zxw
 * @date 2020-11-03 17:31:28
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="MdmPositionCustomerOrgServiceExpandImpl")
public class MdmPositionCustomerOrgServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<MdmPositionCustomerOrgMapper, MdmPositionCustomerOrgEntity> implements MdmPositionCustomerOrgService {

    @Resource
    private MdmPositionCustomerOrgMapper mdmPositionCustomerOrgMapper;

    @Override
    public PageResult<MdmPositionCustomerOrgRespVo> unRelationPage(MdmPositionCustomerOrgPageReqVo mdmPositionCustomerOrgPageReqVo) {
        String customerOrgCode = mdmPositionCustomerOrgPageReqVo.getCustomerOrgCode();
        Assert.hasText(customerOrgCode,"客户组织编码不能为空");
        Page page = PageUtil.buildPage(mdmPositionCustomerOrgPageReqVo.getPageNum(), mdmPositionCustomerOrgPageReqVo.getPageSize());
        List<String> positionCodeList=mdmPositionCustomerOrgMapper.findRelationPosition(customerOrgCode);
        mdmPositionCustomerOrgPageReqVo.setPositionCodeList(positionCodeList);
        List<MdmPositionCustomerOrgRespVo> data = mdmPositionCustomerOrgMapper.unRelationPage(page, mdmPositionCustomerOrgPageReqVo);
        return PageResult.<MdmPositionCustomerOrgRespVo>builder()
                .data(data)
                .count(page.getTotal())
                .build();
    }

    @Override
    public List<MdmPositionCustomerOrgRespVo> relationList(MdmPositionCustomerOrgPageReqVo mdmPositionCustomerOrgPageReqVo) {
        Assert.hasText(mdmPositionCustomerOrgPageReqVo.getCustomerOrgCode(),"客户编码不能为空");
        return mdmPositionCustomerOrgMapper.relationList(mdmPositionCustomerOrgPageReqVo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void add(MdmPositionCustomerOrgUpdateReqVo mdmPositionCustomerOrgUpdateReqVo) {
        String customerOrgCode = mdmPositionCustomerOrgUpdateReqVo.getCustomerOrgCode();
        List<String> positionCodeList = mdmPositionCustomerOrgUpdateReqVo.getPositionCodeList();
        Assert.hasText(customerOrgCode,"客户组织编码不能为空");
        Assert.notNull(positionCodeList,"职位编码集合不能为空");
        List<MdmPositionCustomerOrgEntity> collect = positionCodeList.stream().map(positionCode -> {
            MdmPositionCustomerOrgEntity mdmPositionCustomerOrgEntity = new MdmPositionCustomerOrgEntity();
            mdmPositionCustomerOrgEntity.setPositionCode(positionCode);
            mdmPositionCustomerOrgEntity.setCustomerOrgCode(customerOrgCode);
            mdmPositionCustomerOrgEntity.setId(positionCode + customerOrgCode);
            return mdmPositionCustomerOrgEntity;
        }).collect(Collectors.toList());
        this.saveOrUpdateBatch(collect);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void remove(MdmPositionCustomerOrgUpdateReqVo mdmPositionCustomerOrgUpdateReqVo) {
        String customerOrgCode = mdmPositionCustomerOrgUpdateReqVo.getCustomerOrgCode();
        List<String> positionCodeList = mdmPositionCustomerOrgUpdateReqVo.getPositionCodeList();
        Assert.hasText(customerOrgCode,"客户组织编码不能为空");
        Assert.notNull(positionCodeList,"职位编码集合不能为空");
        this.lambdaUpdate()
                .eq(MdmPositionCustomerOrgEntity::getCustomerOrgCode, customerOrgCode)
                .in(MdmPositionCustomerOrgEntity::getPositionCode, positionCodeList)
                .remove();
    }
}
