package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.customer.service.MdmCustomerSupplyService;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRelationCustomerPageRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.position.mapper.MdmPositionRelationCustomerMapper;
import com.biz.crm.position.model.MdmCustomerSupplyEntity;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.MdmPositionRelationCustomerService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@ConditionalOnMissingBean(name = "MdmPositionRelationCustomerServiceExpandImpl")
public class MdmPositionRelationCustomerServiceImpl implements MdmPositionRelationCustomerService {

    @Resource
    private MdmPositionRelationCustomerMapper mdmPositionRelationCustomerMapper;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmCustomerSupplyService mdmCustomerSupplyService;
    @Resource
    private MdmCustomerROrgService mdmCustomerROrgService;


    @Override
    public PageResult<MdmPositionRelationCustomerPageRespVo> findCustomerNotRelateAnyPosition(MdmPositionRelationCustomerPageReqVo reqVo) {
        Page<MdmPositionRelationCustomerPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmPositionRelationCustomerPageRespVo> list = mdmPositionRelationCustomerMapper.findCustomerNotRelateAnyPosition(page, reqVo);
        setOrgName(list);
        return PageResult.<MdmPositionRelationCustomerPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<MdmPositionRelationCustomerPageRespVo> findCustomerNotRelateCurPosition(MdmPositionRelationCustomerPageReqVo reqVo) {
        Page<MdmPositionRelationCustomerPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        Assert.hasText(reqVo.getPositionCode(), "缺失职位编码");
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmPositionRelationCustomerPageRespVo> list = mdmPositionRelationCustomerMapper.findCustomerNotRelateCurPosition(page, reqVo);
        setOrgName(list);
        setPositionCodeName(list);
        return PageResult.<MdmPositionRelationCustomerPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<MdmPositionRelationCustomerPageRespVo> findCustomerHasRelateCurPosition(MdmPositionRelationCustomerPageReqVo reqVo) {
        Page<MdmPositionRelationCustomerPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmPositionRelationCustomerPageRespVo> list = mdmPositionRelationCustomerMapper.findCustomerHasRelateCurPosition(page, reqVo);
        setOrgName(list);
        Assert.hasText(reqVo.getPositionCode(), "缺失职位编码");
        return PageResult.<MdmPositionRelationCustomerPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void bindRelation(List<String> customerCodeList, String positionCode) {
        Assert.notEmpty(customerCodeList, "缺失客户编码");
        Assert.hasText(positionCode, "缺失职位编码");
        MdmPositionRespVo position = mdmPositionService.queryByPositionCode(positionCode);
        Assert.notNull(position, "无效的职位编码");
        customerCodeList.forEach(customerCode -> {
            mdmCustomerSupplyService.addRelation(customerCode, position.getPositionCode(), position.getOrgCode());
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void replaceCustomerPosition(List<String> ids, String positionCode) {
        Assert.notEmpty(ids, "缺失id");
        Assert.hasText(positionCode, "缺失职位编码");
        MdmPositionRespVo position = mdmPositionService.queryByPositionCode(positionCode);
        Assert.notNull(position, "无效的职位编码");
        mdmCustomerSupplyService.replacePosition(ids, positionCode, position.getOrgCode());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void unbindRelation(List<String> ids) {
        Assert.notEmpty(ids, "缺失id");
        mdmCustomerSupplyService.removeRelations(ids);
    }

    protected void setOrgName(List<MdmPositionRelationCustomerPageRespVo> list) {
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        final Map<String, List<MdmOrgRespVo>> map = mdmCustomerROrgService.findOrgGroupByCustomerCodeList(list.stream().map(MdmPositionRelationCustomerPageRespVo::getCustomerCode).collect(Collectors.toList()));
        list.forEach(item -> {
            if (map.containsKey(item.getCustomerCode())) {
                List<MdmOrgRespVo> orgList = map.get(item.getCustomerCode());
                item.setOrgName(orgList.stream().map(MdmOrgRespVo::getOrgName).collect(Collectors.joining(",")));
            }
        });
    }

    protected void setPositionCodeName(List<MdmPositionRelationCustomerPageRespVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<String> terminalCodeList = list.stream().map(MdmPositionRelationCustomerPageRespVo::getCustomerCode).collect(Collectors.toList());

            List<MdmCustomerSupplyEntity> terminalSupplyList = mdmCustomerSupplyService.lambdaQuery()
                    .in(MdmCustomerSupplyEntity::getCustomerCode, terminalCodeList)
                    .select(MdmCustomerSupplyEntity::getCustomerCode, MdmCustomerSupplyEntity::getPositionCode)
                    .list();
            List<String> positionCodeList = terminalSupplyList.stream().map(MdmCustomerSupplyEntity::getPositionCode).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
                List<MdmPositionEntity> positionList = mdmPositionService.lambdaQuery()
                        .eq(MdmPositionEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
                        .in(MdmPositionEntity::getPositionCode, positionCodeList)
                        .select(MdmPositionEntity::getPositionCode, MdmPositionEntity::getPositionName)
                        .list();
                if (CollectionUtil.listNotEmptyNotSizeZero(positionList)) {
                    final Map<String, MdmPositionEntity> positionMap = positionList.stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, v -> v));
                    final Map<String, List<String>> collect = terminalSupplyList.stream().filter(item -> StringUtils.isNotEmpty(item.getPositionCode())).collect(Collectors.groupingBy(MdmCustomerSupplyEntity::getCustomerCode, Collectors.mapping(MdmCustomerSupplyEntity::getPositionCode, Collectors.toList())));
                    list.forEach(item -> {
                        if (collect.containsKey(item.getCustomerCode())) {
                            List<String> positionCodeListInThisCustomer = collect.get(item.getCustomerCode());
                            List<MdmPositionEntity> positionListInThisCustomer = new ArrayList<>();
                            for (String positionCode :
                                    positionCodeListInThisCustomer) {
                                if (positionMap.containsKey(positionCode)) {
                                    positionListInThisCustomer.add(positionMap.get(positionCode));
                                }
                            }
                            item.setPositionCode(positionListInThisCustomer.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.joining(",")));
                            item.setPositionName(positionListInThisCustomer.stream().map(MdmPositionEntity::getPositionName).collect(Collectors.joining(",")));
                        }
                    });
                }
            }
        }
    }
}
