package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRelationTerminalPageRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.position.mapper.MdmPositionRelationTerminalMapper;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.MdmPositionRelationTerminalService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.terminal.model.MdmTerminalSupplyEntity;
import com.biz.crm.terminal.service.MdmTerminalROrgService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@ConditionalOnMissingBean(name = "MdmPositionRelationTerminalServiceExpandImpl")
public class MdmPositionRelationTerminalServiceImpl implements MdmPositionRelationTerminalService {

    @Resource
    private MdmPositionRelationTerminalMapper mdmPositionRelationTerminalMapper;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmTerminalSupplyService mdmTerminalSupplyService;
    @Resource
    private MdmTerminalROrgService mdmTerminalROrgService;

    @Override
    public PageResult<MdmPositionRelationTerminalPageRespVo> findTerminalNotRelateAnyPosition(MdmPositionRelationTerminalPageReqVo reqVo) {
        Page<MdmPositionRelationTerminalPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmPositionRelationTerminalPageRespVo> list = mdmPositionRelationTerminalMapper.findTerminalNotRelateAnyPosition(page, reqVo);
        setOrgName(list);
        return PageResult.<MdmPositionRelationTerminalPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<MdmPositionRelationTerminalPageRespVo> findTerminalNotRelateCurPosition(MdmPositionRelationTerminalPageReqVo reqVo) {
        Page<MdmPositionRelationTerminalPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        Assert.hasText(reqVo.getPositionCode(), "缺失职位编码");
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmPositionRelationTerminalPageRespVo> list = mdmPositionRelationTerminalMapper.findTerminalNotRelateCurPosition(page, reqVo);
        setOrgName(list);
        setPositionCodeName(list);
        return PageResult.<MdmPositionRelationTerminalPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<MdmPositionRelationTerminalPageRespVo> findTerminalHasRelateCurPosition(MdmPositionRelationTerminalPageReqVo reqVo) {
        Page<MdmPositionRelationTerminalPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmPositionRelationTerminalPageRespVo> list = mdmPositionRelationTerminalMapper.findTerminalHasRelateCurPosition(page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> {
                item.setId(item.getSupplyId());
            });
        }
        setOrgName(list);
        Assert.hasText(reqVo.getPositionCode(), "缺失职位编码");
        return PageResult.<MdmPositionRelationTerminalPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void bindRelation(List<String> terminalCodeList, String positionCode) {
        Assert.notEmpty(terminalCodeList, "缺失终端编码");
        Assert.hasText(positionCode, "缺失职位编码");
        MdmPositionRespVo position = mdmPositionService.queryByPositionCode(positionCode);
        Assert.notNull(position, "无效的职位编码");
        mdmTerminalSupplyService.addTerminalPosition(terminalCodeList, positionCode, position.getOrgCode());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void replaceTerminalPosition(List<String> ids, String positionCode) {
        Assert.notEmpty(ids, "缺失id");
        Assert.hasText(positionCode, "缺失职位编码");
        MdmPositionRespVo position = mdmPositionService.queryByPositionCode(positionCode);
        Assert.notNull(position, "无效的职位编码");
        mdmTerminalSupplyService.replaceRelationPosition(ids, positionCode, position.getOrgCode());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void unbindRelation(List<String> ids) {
        Assert.notEmpty(ids, "缺失id");
        mdmTerminalSupplyService.unbindByIds(ids);
    }

    protected void setOrgName(List<MdmPositionRelationTerminalPageRespVo> list) {
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        final Map<String, List<MdmOrgRespVo>> map = mdmTerminalROrgService.findOrgGroupByTerminalCodeList(list.stream().map(MdmPositionRelationTerminalPageRespVo::getTerminalCode).collect(Collectors.toList()));
        list.forEach(item -> {
            if (map.containsKey(item.getTerminalCode())) {
                List<MdmOrgRespVo> orgList = map.get(item.getTerminalCode());
                item.setOrgName(orgList.stream().map(MdmOrgRespVo::getOrgName).collect(Collectors.joining(",")));
            }
        });
    }

    protected void setPositionCodeName(List<MdmPositionRelationTerminalPageRespVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<String> terminalCodeList = list.stream().map(MdmPositionRelationTerminalPageRespVo::getTerminalCode).collect(Collectors.toList());
            List<MdmTerminalSupplyVo> terminalSupplyList = mdmTerminalSupplyService.findTerminalSupply(new MdmTerminalVo().setTerminalCodeList(terminalCodeList));
            List<String> positionCodeList = terminalSupplyList.stream().map(MdmTerminalSupplyVo::getPositionCode).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
                final Map<String, MdmPositionRespVo> positionMap = mdmPositionService.queryBatchByPositionCodeList(positionCodeList)
                        .stream()
                        .collect(Collectors.toMap(MdmPositionRespVo::getPositionCode, v -> v));
                if (!positionMap.isEmpty()) {
                    final Map<String, List<String>> collect = terminalSupplyList.stream().filter(item -> StringUtils.isNotEmpty(item.getPositionCode())).collect(Collectors.groupingBy(MdmTerminalSupplyVo::getTerminalCode, Collectors.mapping(MdmTerminalSupplyVo::getPositionCode, Collectors.toList())));
                    list.forEach(item -> {
                        if (collect.containsKey(item.getTerminalCode())) {
                            List<String> positionCodeListInThisTerminal = collect.get(item.getTerminalCode());
                            List<MdmPositionRespVo> positionListInThisTerminal = new ArrayList<>();
                            for (String positionCode :
                                    positionCodeListInThisTerminal) {
                                if (positionMap.containsKey(positionCode)) {
                                    positionListInThisTerminal.add(positionMap.get(positionCode));
                                }
                            }
                            item.setPositionCode(positionListInThisTerminal.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.joining(",")));
                            item.setPositionName(positionListInThisTerminal.stream().map(MdmPositionRespVo::getPositionName).collect(Collectors.joining(",")));
                        }
                    });
                }
            }
        }
    }
}
