package com.biz.crm.positionlevel.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.position.req.MdmPositionReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelReqVo;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelSelectReqVo;
import com.biz.crm.nebular.mdm.positionlevel.resp.MdmPositionLevelRespVo;
import com.biz.crm.nebular.mdm.positionlevel.resp.MdmPositionLevelSelectRespVo;
import com.biz.crm.positionlevel.model.MdmPositionLevelEntity;

import java.util.List;

/**
 * 职位级别 接口
 *
 * @author Tao.Chen
 * @date 2020-10-22 10:56:51
 */
public interface MdmPositionLevelService extends IService<MdmPositionLevelEntity> {

    /**
     * 列表
     *
     * @param mdmPositionLevelReqVo
     * @return PageResult<MdmPositionLevelRespVo>
     */
    PageResult<MdmPositionLevelRespVo> findList(MdmPositionLevelReqVo mdmPositionLevelReqVo);

    /**
     * 查询编辑页面详情
     *
     * @param id
     * @return
     */
    MdmPositionLevelRespVo queryForUpdate(String id);

    /**
     * 查询
     *
     * @param id
     * @param positionLevelCode
     * @return
     */
    MdmPositionLevelRespVo detail(String id, String positionLevelCode);

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    void save(MdmPositionLevelReqVo reqVo);

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    void update(MdmPositionLevelReqVo reqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 查询职位级别下拉框选择数据
     *
     * @param reqVo
     * @return
     */
    List<MdmPositionLevelSelectRespVo> selectList(MdmPositionLevelSelectReqVo reqVo);

    public String generatePositionNameByPositionLevelCode(String positionLevelCode);
}

