package com.biz.crm.pricesetting.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionGroupReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionGroupRespVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceOperationCheckRespVo;
import com.biz.crm.pricesetting.service.MdmPriceConditionGroupService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 条件字段分类主表
 *
 * @author huanglong
 * @date 2020-10-14 17:21:40
 */
@Slf4j
@RestController
@RequestMapping("/mdmPriceConditionGroupController")
@Api(tags = "条件字段分类")
@CrmGlobalLog
public class MdmPriceConditionGroupController {

    @Autowired
    private MdmPriceConditionGroupService mdmPriceConditionGroupService;

    @ApiOperation(value = "查询分页列表")
    @PostMapping("/list")
    public Result<PageResult<MdmPriceConditionGroupRespVo>> list(@RequestBody MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo) {
        PageResult<MdmPriceConditionGroupRespVo> result = mdmPriceConditionGroupService.findList(mdmPriceConditionGroupReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "根据id查询详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true, paramType = "query")
    })
    @GetMapping("/query")
    public Result<MdmPriceConditionGroupRespVo> query(@RequestParam("id") String id) {
        MdmPriceConditionGroupRespVo respVo = mdmPriceConditionGroupService.query(id, null);
        return Result.ok(respVo);
    }

    @ApiOperation(value = "根据id查询是否可以编辑")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true, paramType = "query")
    })
    @GetMapping("/editCheck")
    public Result<MdmPriceOperationCheckRespVo> editCheck(@RequestParam("id") String id) {
        return Result.ok(mdmPriceConditionGroupService.editCheck(id));
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result save(@RequestBody MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo) {
        mdmPriceConditionGroupService.save(mdmPriceConditionGroupReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result update(@RequestBody MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo) {
        mdmPriceConditionGroupService.update(mdmPriceConditionGroupReqVo);
        return Result.ok("修改成功");
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    public Result delete(@RequestBody List<String> ids) {
        mdmPriceConditionGroupService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "查询集合")
    @PostMapping("/findCollection")
    public Result<List<MdmPriceConditionGroupRespVo>> findCollection(@RequestBody MdmPriceConditionGroupReqVo reqVo) {
        return Result.ok(mdmPriceConditionGroupService.findCollection(reqVo));
    }
}
