package com.biz.crm.pricesetting.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionTypeReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionTypeRelGroupRespVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionTypeRespVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceOperationCheckRespVo;
import com.biz.crm.pricesetting.service.MdmPriceConditionTypeService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 条件字段类型主表
 *
 * @author huanglong
 * @date 2020-10-20 10:57:00
 */
@Slf4j
@RestController
@RequestMapping("/mdmPriceConditionTypeController")
@Api(tags = "条件类型")
@CrmGlobalLog
public class MdmPriceConditionTypeController {

    @Autowired
    private MdmPriceConditionTypeService mdmPriceConditionTypeService;

    @ApiOperation(value = "查询分页列表")
    @PostMapping("/list")
    @CrmDictMethod
    public Result<PageResult<MdmPriceConditionTypeRespVo>> list(@RequestBody MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo) {
        PageResult<MdmPriceConditionTypeRespVo> result = mdmPriceConditionTypeService.findList(mdmPriceConditionTypeReqVo);
        return Result.ok(result);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true, paramType = "query")
    })
    @ApiOperation(value = "根据id查询条件类型详情")
    @GetMapping("/query")
    @CrmDictMethod
    public Result<MdmPriceConditionTypeRespVo> query(@RequestParam("id") String id) {
        MdmPriceConditionTypeRespVo respVo = mdmPriceConditionTypeService.query(id, null);
        return Result.ok(respVo);
    }

    @ApiOperation(value = "根据id查询是否可以编辑")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true, paramType = "query")
    })
    @GetMapping("/editCheck")
    public Result<MdmPriceOperationCheckRespVo> editCheck(@RequestParam("id") String id) {
        return Result.ok(mdmPriceConditionTypeService.editCheck(id));
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result save(@RequestBody MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo) {
        mdmPriceConditionTypeService.save(mdmPriceConditionTypeReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result update(@RequestBody MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo) {
        mdmPriceConditionTypeService.update(mdmPriceConditionTypeReqVo);
        return Result.ok("修改成功");
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    public Result delete(@RequestBody List<String> ids) {
        mdmPriceConditionTypeService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "条件类型下拉框（名称格式为：编码/名称）")
    @PostMapping("/priceConditionTypeSelectList")
    @CrmDictMethod
    public Result<List<MdmPriceConditionTypeRespVo>> priceConditionTypeSelectList(@RequestBody MdmPriceConditionTypeReqVo reqVo) {
        return Result.ok(mdmPriceConditionTypeService.priceConditionTypeSelectList(reqVo));
    }

    @ApiOperation(value = "根据条件类型编码查询条件分类数据")
    @PostMapping("/groupByConditionType")
    public Result<List<MdmPriceConditionTypeRelGroupRespVo>> groupByConditionType(@RequestBody MdmPriceConditionTypeReqVo reqVo) {
        return Result.ok(mdmPriceConditionTypeService.groupByConditionType(reqVo));
    }
}
