package com.biz.crm.pricesetting.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionTypeReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionTypeRespVo;
import com.biz.crm.pricesetting.model.MdmPriceConditionTypeEntity;
import com.biz.crm.pricesetting.provider.MdmPriceConditionProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * 条件字段类型主表
 *
 * @author huanglong
 * @date 2020-10-20 10:57:00
 */
public interface MdmPriceConditionTypeMapper extends BaseMapper<MdmPriceConditionTypeEntity> {

    /**
     * 列表
     *
     * @param page
     * @param mdmPriceConditionTypeReqVo
     * @return
     */
    List<MdmPriceConditionTypeRespVo> findList(Page<MdmPriceConditionTypeRespVo> page,
                                               @Param("vo") MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo);

    /**
     * 列表
     *
     * @param page
     * @param mdmPriceConditionTypeReqVo
     * @return
     */
    @SelectProvider(type = MdmPriceConditionProvider.class,method = "findListType")
    List<MdmPriceConditionTypeRespVo> findListType(Page<MdmPriceConditionTypeRespVo> page,
                                               @Param("vo") MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo);
}
