package com.biz.crm.pricesetting.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionGroupReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionGroupRespVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceOperationCheckRespVo;
import com.biz.crm.pricesetting.model.MdmPriceConditionGroupEntity;

import java.util.List;
import java.util.Map;

/**
 * 条件字段分类主表 接口
 *
 * @author huanglong
 * @date 2020-10-14 17:21:40
 */
public interface MdmPriceConditionGroupService extends IService<MdmPriceConditionGroupEntity> {

    /**
     * 列表
     * @param mdmPriceConditionGroupReqVo
     * @return PageResult<MdmPriceConditionGroupRespVo>
     */
    PageResult<MdmPriceConditionGroupRespVo> findList(MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo);

    /**
     * 查询
     * @param id
     * @return MdmPriceConditionGroupRespVo
     */
    MdmPriceConditionGroupRespVo query(String id,String conditionGroupCode);

    /**
     * 编辑前校验
     *
     * @param id
     */
    MdmPriceOperationCheckRespVo editCheck(String id);

    /**
     * 新增
     * @param mdmPriceConditionGroupReqVo
     * @return
     */
    void save(MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo);

    /**
     * 更新
     * @param mdmPriceConditionGroupReqVo
     * @return
     */
    void update(MdmPriceConditionGroupReqVo mdmPriceConditionGroupReqVo);


    /**
     * 删除
     * @param ids
     */
    void deleteBatch(List<String> ids);

    List<MdmPriceConditionGroupRespVo> findCollection(MdmPriceConditionGroupReqVo reqVo);

    /**
     * 获取条件字段分类编码名称map
     *
     * @return
     */
    Map<String, String> getGroupMap();

    /**
     * 获取条件字段分类编码名称map
     *
     * @param conditionGroupCodeList 条件字段分类编码
     * @return
     */
    Map<String, String> getGroupMap(List<String> conditionGroupCodeList);


}

