package com.biz.crm.pricesetting.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.pricesetting.model.MdmPriceConditionTypeRelGroupEntity;

import java.util.List;
import java.util.Map;

/**
 * 条件字段类型和条件字段分类的关系表 接口
 *
 * @author huanglong
 * @date 2020-10-20 10:57:01
 */
public interface MdmPriceConditionTypeRelGroupService extends IService<MdmPriceConditionTypeRelGroupEntity> {

    /**
     * 根据类型编码获取高优先级分类编码
     *
     * @param conditionTypeCodeList 类型编码集合
     * @return map
     */
    Map<String, List<String>> groupPriorityList(List<String> conditionTypeCodeList);

    Map<String, List<List<String>>> groupList(List<String> conditionTypeCodeList);
}

