package com.biz.crm.pricesetting.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionTypeReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionTypeRelGroupRespVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionTypeRespVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceOperationCheckRespVo;
import com.biz.crm.pricesetting.model.MdmPriceConditionTypeEntity;

import java.util.List;

/**
 * 条件字段类型主表 接口
 *
 * @author huanglong
 * @date 2020-10-20 10:57:00
 */
public interface MdmPriceConditionTypeService extends IService<MdmPriceConditionTypeEntity> {

    /**
     * 分页列表
     *
     * @param mdmPriceConditionTypeReqVo
     * @return PageResult<MdmPriceConditionTypeRespVo>
     */
    PageResult<MdmPriceConditionTypeRespVo> findList(MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo);

    /**
     * 条件类型下拉框（名称格式为：编码/名称）
     *
     * @param mdmPriceConditionTypeReqVo
     * @return
     */
    List<MdmPriceConditionTypeRespVo> priceConditionTypeSelectList(MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo);

    /**
     * 详情
     *
     * @param id
     * @param conditionTypeCode
     * @return
     */
    MdmPriceConditionTypeRespVo query(String id, String conditionTypeCode);

    /**
     * 编辑前校验
     *
     * @param id
     */
    MdmPriceOperationCheckRespVo editCheck(String id);

    /**
     * 新增
     *
     * @param mdmPriceConditionTypeReqVo
     * @return
     */
    void save(MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo);

    /**
     * 更新
     *
     * @param mdmPriceConditionTypeReqVo
     * @return
     */
    void update(MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo);

    /**
     * 删除
     *
     * @param ids
     */
    void deleteBatch(List<String> ids);

    /**
     * 根据条件类型编码查询条件分类数据
     *
     * @param mdmPriceConditionTypeReqVo
     * @return
     */
    List<MdmPriceConditionTypeRelGroupRespVo> groupByConditionType(MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo);
}

