package com.biz.crm.product.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.product.req.MdmProductMaterialReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMaterialRespVo;
import com.biz.crm.product.model.MdmProductMaterialEntity;

import java.util.List;

/**
 * 接口
 *
 * @author crm
 * @date 2020-08-27 17:34:16
 */
public interface MdmProductMaterialService extends IService<MdmProductMaterialEntity> {

    /**
     * 列表
     * @param mdmProductMaterialReqVo
     * @return PageResult<MdmProductMaterialRespVo>
     */
    PageResult<MdmProductMaterialRespVo> findList(MdmProductMaterialReqVo mdmProductMaterialReqVo);

    /**
     * 查询商品关联物料列表
     *
     * @param mdmProductMaterialReqVo
     * @return
     */
    List<MdmProductMaterialRespVo> findProductMaterialList(MdmProductMaterialReqVo mdmProductMaterialReqVo);

    /**
     * 查询
     * @param mdmProductMaterialReqVo
     * @return MdmProductMaterialRespVo
     */
    MdmProductMaterialRespVo query(MdmProductMaterialReqVo mdmProductMaterialReqVo);

    /**
     * 新增
     * @param mdmProductMaterialReqVo
     * @return
     */
    void save(MdmProductMaterialReqVo mdmProductMaterialReqVo);

    /**
     * 更新
     * @param mdmProductMaterialReqVo
     * @return
     */
    void update(MdmProductMaterialReqVo mdmProductMaterialReqVo);

    /**
     * 删除
     * @param mdmProductMaterialReqVo
     * @return
     */
    void deleteBatch(MdmProductMaterialReqVo mdmProductMaterialReqVo);

    /**
     * 启用
     * @param mdmProductMaterialReqVo
     * @return
     */
    void enableBatch(MdmProductMaterialReqVo mdmProductMaterialReqVo);

    /**
     * 禁用
     * @param mdmProductMaterialReqVo
     * @return
     */
    void disableBatch(MdmProductMaterialReqVo mdmProductMaterialReqVo);
}

