package com.biz.crm.product.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.product.req.MdmProductMediaReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMediaRespVo;
import com.biz.crm.product.model.MdmProductMediaEntity;

import java.util.List;

/**
 * 接口
 *
 * @author crm
 * @date 2020-08-27 17:34:16
 */
public interface MdmProductMediaService extends IService<MdmProductMediaEntity> {

    /**
     * 列表
     * @param mdmProductMediaReqVo
     * @return PageResult<MdmProductPictureRespVo>
     */
    PageResult<MdmProductMediaRespVo> findList(MdmProductMediaReqVo mdmProductMediaReqVo);

    List<MdmProductMediaRespVo> list(MdmProductMediaReqVo mdmProductMediaReqVo);

    /**
     * 查询
     * @param mdmProductMediaReqVo
     * @return MdmProductPictureRespVo
     */
    MdmProductMediaRespVo query(MdmProductMediaReqVo mdmProductMediaReqVo);

    /**
     * 新增
     * @param mdmProductMediaReqVo
     * @return
     */
    void save(MdmProductMediaReqVo mdmProductMediaReqVo);

    /**
     * 更新
     * @param mdmProductMediaReqVo
     * @return
     */
    void update(MdmProductMediaReqVo mdmProductMediaReqVo);

    /**
     * 删除
     * @param mdmProductMediaReqVo
     * @return
     */
    void deleteBatch(MdmProductMediaReqVo mdmProductMediaReqVo);

    /**
     * 启用
     * @param mdmProductMediaReqVo
     * @return
     */
    void enableBatch(MdmProductMediaReqVo mdmProductMediaReqVo);

    /**
     * 禁用
     * @param mdmProductMediaReqVo
     * @return
     */
    void disableBatch(MdmProductMediaReqVo mdmProductMediaReqVo);

    /**
     * 根据商品编码查询图片信息
     *
     * @param productCodeList
     * @return
     */
    List<MdmProductMediaRespVo> queryBatchProductPictureList(List<String> productCodeList);
}

