package com.biz.crm.product.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.availablelist.CusAvailablelistVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceProductUnitRespVo;
import com.biz.crm.nebular.mdm.product.req.*;
import com.biz.crm.nebular.mdm.product.resp.*;
import com.biz.crm.product.model.MdmProductEntity;

import java.util.List;
import java.util.Map;

/**
 * 商品主表接口
 *
 * @author crm
 * @date 2020-08-27 17:34:16
 */
public interface MdmProductService extends IService<MdmProductEntity> {

    /**
     * 列表
     *
     * @param mdmProductReqVo
     * @return PageResult<MdmProductRespVo>
     */
    PageResult<MdmProductRespVo> findList(MdmProductReqVo mdmProductReqVo);

    /**
     * 查询
     *
     * @param id
     * @param productCode
     * @return MdmProductRespVo
     */
    MdmProductRespVo detail(String id, String productCode);

    /**
     * 根据编码或者id查询商品头表信息
     * 传id集合或者编码集合，都传取并集
     *
     * @param ids             id集合
     * @param productCodeList 商品编码集合
     * @return
     */
    List<MdmProductRespVo> queryBatch(List<String> ids, List<String> productCodeList);

    /**
     * 通过产品层级编码集合批量查询商品主表信息（产品层级及下级的全部下级层级关联的商品）
     *
     * @param productLevelCodeList 产品层级编码集合
     * @return
     */
    List<MdmProductRespVo> queryBatchByProductLevelCodeList(List<String> productLevelCodeList);

    /**
     * 根据条件查询商品
     *
     * @param reqVo
     * @return
     */
    List<MdmProductQueryRespVo> queryProductList(MdmProductQueryReqVo reqVo);

    /**
     * 根据商品编码集合，查询所有商品信息，并处理关联关系成json串
     *
     * @param productCodeList
     * @return
     */
    List<MdmProductAdviseRespVo> adviseQuery(List<String> productCodeList);

    /**
     * 订单算价查询商品接口
     *
     * @return
     */
    Map<String, MdmProductAdviseAndPriceRespVo> queryByProductCodeAndCus(MdmProductAdviseAndPriceReqVo mdmProductAdviseAndPriceReqVo);

    /**
     * 新增
     *
     * @param mdmProductReqVo
     * @return
     */
    void save(MdmProductReqVo mdmProductReqVo);

    /**
     * 更新
     *
     * @param mdmProductReqVo
     * @return
     */
    void update(MdmProductReqVo mdmProductReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 上架
     *
     * @param ids
     */
    void upShelf(List<String> ids);

    /**
     * 下架
     *
     * @param ids
     */
    void downShelf(List<String> ids);

    void sendChangeMsg(List<String> productCodeList);

    void sendDelMsg(List<String> productCodeList);

    /**
     * 根据商品编码集合查询物料销售公司
     *
     * @param productCodeList 商品编码集合
     * @return map
     */
    Map<String, List<MdmProductSaleCompanyRespVo>> findSaleCompanyByProductCodeList(List<String> productCodeList);

    /**
     * 商品和产品层级一起查
     *
     * @param reqVo
     * @return
     */
    List<MdmProductAndProductLevelRespVo> findProductAndProductLevelByCodeOrName(MdmProductAndProductLevelReqVo reqVo);

    /**
     * 商品下拉框
     *
     * @param reqVo
     * @return
     */
    List<MdmProductSelectRespVo> productSelectList(MdmProductSelectReqVo reqVo);

    /**
     * 查询商品单位
     *
     * @param productCode 商品编码
     * @return
     */
    List<MdmPriceProductUnitRespVo> findProductUnit(String productCode);

    /**
     * 条件查询列表
     *
     * @param mdmProductReqVo vo
     * @return list
     */
    List<MdmProductRespVo> listCondition(MdmProductReqVo mdmProductReqVo);

    /**
     * 查询上架商品及价格
     *
     * @param mdmProductShelfPriceReqVo vo
     * @return list
     */
    List<CusAvailablelistVo> queryShelfProductList(MdmProductShelfPriceReqVo mdmProductShelfPriceReqVo);


    /**
     * sfa查询商品列表专用接口
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmProductBySfaRespVo> findProductListSourceSfa(MdmProductBySfaReqVo reqVo);

    /**
     * sfa tpm活动查询商品基础信息
     * @param productCodeList
     * @return
     */
    List<MdmProductBaseDataRespVo> findProductBaseSourceSfaTpmAct(List<String> productCodeList);

    /**
     *
     * @param mdmProductReqVo mdmProductReqVo
     * @return PageResult<MdmProductRespVo>
     */
    PageResult<MdmProductRespVo> pageListWithCondition(MdmProductReqVo mdmProductReqVo);
}

