package com.biz.crm.product.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.product.req.MdmProductIntroductionReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductIntroductionRespVo;
import com.biz.crm.product.mapper.MdmProductIntroductionMapper;
import com.biz.crm.product.model.MdmProductIntroductionEntity;
import com.biz.crm.product.service.IMdmProductIntroductionService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 接口实现
 *
 * @author huang.long
 * @date 2020-09-01 15:18:14
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="MdmProductIntroductionServiceExpandImpl")
public class MdmProductIntroductionServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<MdmProductIntroductionMapper, MdmProductIntroductionEntity> implements IMdmProductIntroductionService {

    @Autowired
    private MdmProductIntroductionMapper mdmProductIntroductionMapper;

    /**
     * 列表
     * @param mdmProductIntroductionReqVo
     * @return
     */
    @Override
    public PageResult<MdmProductIntroductionRespVo> findList(MdmProductIntroductionReqVo mdmProductIntroductionReqVo){
        Page<MdmProductIntroductionRespVo> page = PageUtil.buildPage(mdmProductIntroductionReqVo.getPageNum(), mdmProductIntroductionReqVo.getPageSize());
        List<MdmProductIntroductionRespVo> list = mdmProductIntroductionMapper.findList(page, mdmProductIntroductionReqVo);
        return PageResult.<MdmProductIntroductionRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param mdmProductIntroductionReqVo
     * @return mdmProductIntroductionRespVo
     */
    @Override
    public MdmProductIntroductionRespVo query(MdmProductIntroductionReqVo mdmProductIntroductionReqVo){
        return null;
    }

    /**
     * 新增
     * @param mdmProductIntroductionReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(MdmProductIntroductionReqVo mdmProductIntroductionReqVo){
        MdmProductIntroductionEntity entity = CrmBeanUtil.copy(mdmProductIntroductionReqVo,MdmProductIntroductionEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param mdmProductIntroductionReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(MdmProductIntroductionReqVo mdmProductIntroductionReqVo){
        MdmProductIntroductionEntity entity = this.getById(mdmProductIntroductionReqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param mdmProductIntroductionReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(MdmProductIntroductionReqVo mdmProductIntroductionReqVo){
        List<MdmProductIntroductionEntity> mdmProductIntroductionEntities = mdmProductIntroductionMapper.selectBatchIds(mdmProductIntroductionReqVo.getIds());
        if(CollectionUtils.isNotEmpty(mdmProductIntroductionEntities)){
            mdmProductIntroductionEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(mdmProductIntroductionEntities);
    }

    /**
     * 启用
     * @param mdmProductIntroductionReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(MdmProductIntroductionReqVo mdmProductIntroductionReqVo){
        //设置状态为启用
        List<MdmProductIntroductionEntity> mdmProductIntroductionEntities = mdmProductIntroductionMapper.selectBatchIds(mdmProductIntroductionReqVo.getIds());
        if(CollectionUtils.isNotEmpty(mdmProductIntroductionEntities)){
            mdmProductIntroductionEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(mdmProductIntroductionEntities);
    }

    /**
     * 禁用
     * @param mdmProductIntroductionReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(MdmProductIntroductionReqVo mdmProductIntroductionReqVo){
        //设置状态为禁用
        List<MdmProductIntroductionEntity> mdmProductIntroductionEntities = mdmProductIntroductionMapper.selectBatchIds(mdmProductIntroductionReqVo.getIds());
        if(CollectionUtils.isNotEmpty(mdmProductIntroductionEntities)){
                mdmProductIntroductionEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(mdmProductIntroductionEntities);
    }
}
