package com.biz.crm.product.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.FileTypeEnum;
import com.biz.crm.nebular.mdm.product.req.MdmProductMediaReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMediaRespVo;
import com.biz.crm.product.mapper.MdmProductMediaMapper;
import com.biz.crm.product.model.MdmProductMediaEntity;
import com.biz.crm.product.service.MdmProductMediaService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 接口实现
 *
 * @author crm
 * @date 2020-08-27 17:34:16
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="MdmProductMediaServiceExpandImpl")
public class MdmProductMediaServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<MdmProductMediaMapper, MdmProductMediaEntity> implements MdmProductMediaService {

    @Autowired
    private MdmProductMediaMapper mdmProductMediaMapper;

    /**
     * 列表
     * @param mdmProductMediaReqVo
     * @return
     */
    @Override
    public PageResult<MdmProductMediaRespVo> findList(MdmProductMediaReqVo mdmProductMediaReqVo){
        Page<MdmProductMediaRespVo> page = PageUtil.buildPage(mdmProductMediaReqVo.getPageNum(), mdmProductMediaReqVo.getPageSize());
        List<MdmProductMediaRespVo> list = mdmProductMediaMapper.findList(page, mdmProductMediaReqVo);
        return PageResult.<MdmProductMediaRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public List<MdmProductMediaRespVo> list(MdmProductMediaReqVo mdmProductMediaReqVo) {
        QueryWrapper<MdmProductMediaEntity> wrapper = Wrappers.<MdmProductMediaEntity>query()
                .eq(!StringUtils.isEmpty(mdmProductMediaReqVo.getProductCode()), "product_code", mdmProductMediaReqVo.getProductCode());
        List<MdmProductMediaEntity> list = this.list(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
           return CrmBeanUtil.copyList(list, MdmProductMediaRespVo.class);
        }
        return new ArrayList<>();
    }

    /**
     * 查询
     * @param mdmProductMediaReqVo
     * @return mdmProductMediaRespVo
     */
    @Override
    public MdmProductMediaRespVo query(MdmProductMediaReqVo mdmProductMediaReqVo){
        return null;
    }

    /**
     * 新增
     * @param mdmProductMediaReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(MdmProductMediaReqVo mdmProductMediaReqVo){
        MdmProductMediaEntity entity = CrmBeanUtil.copy(mdmProductMediaReqVo, MdmProductMediaEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param mdmProductMediaReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(MdmProductMediaReqVo mdmProductMediaReqVo){
        MdmProductMediaEntity entity = this.getById(mdmProductMediaReqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param mdmProductMediaReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(MdmProductMediaReqVo mdmProductMediaReqVo){
        List<MdmProductMediaEntity> mdmProductMediaEntities = mdmProductMediaMapper.selectBatchIds(mdmProductMediaReqVo.getIds());
        if(CollectionUtils.isNotEmpty(mdmProductMediaEntities)){
            mdmProductMediaEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(mdmProductMediaEntities);
    }

    /**
     * 启用
     * @param mdmProductMediaReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(MdmProductMediaReqVo mdmProductMediaReqVo){
        //设置状态为启用
        List<MdmProductMediaEntity> mdmProductMediaEntities = mdmProductMediaMapper.selectBatchIds(mdmProductMediaReqVo.getIds());
        if(CollectionUtils.isNotEmpty(mdmProductMediaEntities)){
            mdmProductMediaEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(mdmProductMediaEntities);
    }

    /**
     * 禁用
     * @param mdmProductMediaReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(MdmProductMediaReqVo mdmProductMediaReqVo){
        //设置状态为禁用
        List<MdmProductMediaEntity> mdmProductMediaEntities = mdmProductMediaMapper.selectBatchIds(mdmProductMediaReqVo.getIds());
        if(CollectionUtils.isNotEmpty(mdmProductMediaEntities)){
                mdmProductMediaEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(mdmProductMediaEntities);
    }

    @Override
    public List<MdmProductMediaRespVo> queryBatchProductPictureList(List<String> productCodeList) {
        List<MdmProductMediaEntity> list = this.lambdaQuery()
                .eq(MdmProductMediaEntity::getType, FileTypeEnum.PICTURE.getCode())
                .in(MdmProductMediaEntity::getProductCode, productCodeList)
                .select(MdmProductMediaEntity::getProductCode, MdmProductMediaEntity::getUrlAddress)
                .list();
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
           return CrmBeanUtil.copyList(list, MdmProductMediaRespVo.class);
        }
        return new ArrayList<>();
    }
}
