package com.biz.crm.productlevel.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.Map;

/**
 * @Author hej
 * @Created Date 2021-01-06 10:49
 **/
public class MdmProductLevelProvider {


    public String findListProvider(Map<String,Object> map){
        List<String> productLevelTypeSortList = (List<String>) map.get("productLevelTypeSortList");
        MdmProductLevelReqVo vo = (MdmProductLevelReqVo) map.get("vo");
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){{
            StringBuilder orderBy = new StringBuilder();
            SELECT("a.*,b.product_level_name as parent_name");
            FROM("mdm_product_level a");
            LEFT_OUTER_JOIN("mdm_product_level b on a.parent_code=b.product_level_code");
            if(StringUtils.isNotEmpty(vo.getRuleCode())){
                orderBy.append("CASE WHEN a.rule_code = #{vo.ruleCode} THEN 1 ELSE 99 END asc,");
                WHERE("a.rule_code like "+ProviderUtil.bindPercent(vo.getRuleCode(),MdmProviderEnum.SQL_JOIN_RIGHT));
            }
            if(StringUtils.isNotEmpty(vo.getEnableStatus())){
                WHERE("a.enable_status=#{vo.enableStatus}");
            }
            if(StringUtils.isNotEmpty(vo.getProductLevelCode())){
                WHERE("a.product_level_code like "+ProviderUtil.bindPercent(vo.getProductLevelCode(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getProductLevelName())){
                WHERE("a.product_level_name like "+ProviderUtil.bindPercent(vo.getProductLevelName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(CollectionUtil.listNotEmptyNotSizeZero(productLevelTypeSortList)){
                orderBy.append(" CASE ");
                for (int i = 0;i<productLevelTypeSortList.size();i++) {
                    String str = productLevelTypeSortList.get(i);
                    orderBy.append(" WHEN a.product_level_type = '"+str+"' THEN "+i+" \n");
                }
                orderBy.append(" ELSE 99 END asc,");
            }
            orderBy.append(" a.product_level_code asc");
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
            }
            ORDER_BY(orderBy.toString());
        }}.toString();
    }
}
