package com.biz.crm.region.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.region.MdmRegionReqVo;
import com.biz.crm.nebular.mdm.region.MdmRegionRespVo;
import com.biz.crm.nebular.mdm.region.MdmRegionSelectReqVo;
import com.biz.crm.nebular.mdm.region.MdmRegionSelectTransportRespVo;
import com.biz.crm.region.model.MdmRegionEntity;
import com.biz.crm.region.provider.MdmRegionProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * 
 * 
 * @author zxw
 * @date 2020-11-20 14:59:37
 */
public interface MdmRegionMapper extends BaseMapper<MdmRegionEntity> {

    List<MdmRegionRespVo> pageList(Page<MdmRegionRespVo> page,@Param("vo") MdmRegionReqVo mdmRegionReqVo);

    @SelectProvider(type = MdmRegionProvider.class,method = "pageListProvider")
    List<MdmRegionRespVo> pageListProvider(Page<MdmRegionRespVo> page,@Param("vo") MdmRegionReqVo mdmRegionReqVo);

    /**
     * 列表
     * @param mdmRegionReqVo vo
     * @return list
     */
    List<MdmRegionRespVo> findList(@Param("vo") MdmRegionReqVo mdmRegionReqVo);

    /**
     * 根据id或编码查询详情
     * @param id id
     * @param regionCode 区域编码
     * @return vo
     */
    MdmRegionRespVo query(@Param("id") String id,@Param("regionCode") String regionCode);

    List<MdmRegionSelectTransportRespVo> regionSelect(Page<MdmRegionSelectTransportRespVo> page, @Param("vo") MdmRegionSelectReqVo vo, @Param("includeList") List<String> includeList, @Param("excludeList") List<String> excludeList);

    /**
     * 查询区域第一层
     * @return list
     */
    List<MdmRegionRespVo> findFirstLevel();
}
