package com.biz.crm.role.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.role.req.MdmRoleRelationPositionPageReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleRelationPositionReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmUnbindRoleRelationPositionReqVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRelationPositionPageRespVo;
import com.biz.crm.role.service.MdmRoleRelationPositionService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("/mdmRoleRelationPositionController")
@Api(tags = "MDM-角色管理-关联职位")
@CrmGlobalLog
public class MdmRoleRelationPositionController {

    @Autowired
    private MdmRoleRelationPositionService mdmRoleRelationPositionService;


    @ApiOperation("查询未关联任何角色的职位")
    @PostMapping("/findPositionNotRelateAnyRoleList")
    @CrmDictMethod
    public Result<PageResult<MdmRoleRelationPositionPageRespVo>> findPositionNotRelateAnyRoleList(@RequestBody MdmRoleRelationPositionPageReqVo mdmRoleRelationPositionPageReqVo) {
        PageResult<MdmRoleRelationPositionPageRespVo> page = mdmRoleRelationPositionService.findPositionNotRelateAnyRoleList(mdmRoleRelationPositionPageReqVo);
        return Result.ok(page);
    }

    @ApiOperation("查询未关联当前角色的职位")
    @PostMapping("/findPositionNotRelateCurRoleList")
    @CrmDictMethod
    public Result<PageResult<MdmRoleRelationPositionPageRespVo>> findPositionNotRelateCurRoleList(@RequestBody MdmRoleRelationPositionPageReqVo mdmRoleRelationPositionPageReqVo) {
        PageResult<MdmRoleRelationPositionPageRespVo> page = mdmRoleRelationPositionService.findPositionNotRelateCurRoleList(mdmRoleRelationPositionPageReqVo);
        return Result.ok(page);
    }

    @ApiOperation("查询已关联当前角色的职位")
    @PostMapping("/findPositionHasRelateCurRoleList")
    @CrmDictMethod
    public Result<PageResult<MdmRoleRelationPositionPageRespVo>> findPositionHasRelateCurRoleList(@RequestBody MdmRoleRelationPositionPageReqVo mdmRoleRelationPositionPageReqVo) {
        PageResult<MdmRoleRelationPositionPageRespVo> page = mdmRoleRelationPositionService.findPositionHasRelateCurRoleList(mdmRoleRelationPositionPageReqVo);
        return Result.ok(page);
    }

    @ApiOperation("职位关联角色")
    @PostMapping("/positionRelationRole")
    public Result<Object> positionRelationRole(@RequestBody MdmRoleRelationPositionReqVo mdmRoleRelationPositionReqVo) {
        mdmRoleRelationPositionService.positionRelationRole(mdmRoleRelationPositionReqVo);
        return Result.ok();
    }

    @ApiOperation("替换职位关联的角色")
    @PostMapping("/replaceBindRole")
    public Result<Object> replaceBindRole(@RequestBody MdmRoleRelationPositionReqVo mdmRoleRelationPositionReqVo) {
        mdmRoleRelationPositionService.replaceBindRole(mdmRoleRelationPositionReqVo);
        return Result.ok();
    }

    @ApiOperation("解除职位关联的角色")
    @PostMapping("/unbindRelationRole")
    public Result<Object> unbindRelationRole(@RequestBody MdmUnbindRoleRelationPositionReqVo reqVo) {
        mdmRoleRelationPositionService.unbindRelationRole(reqVo);
        return Result.ok();
    }

}
