package com.biz.crm.role.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.Map;

/**
 * @Author hej
 * @Created Date 2021-01-07 10:25
 **/
public class MdmRoleProvider {

    public String findListProvider(Map<String, Object> para){
        MdmRoleReqVo vo = (MdmRoleReqVo)para.get("vo");
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){{
            SELECT("*");
            FROM("mdm_role a");
            if(StringUtils.isNotEmpty(vo.getRoleCode())){
                WHERE("a.role_code like" + ProviderUtil.bindPercent(vo.getRoleCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(CollectionUtil.listNotEmptyNotSizeZero(vo.getExcludeRoleCodeList())){
                WHERE("a.role_code not in "+ProviderUtil.gainForeach("(",",",")",vo.getExcludeRoleCodeList()));
            }
            if(StringUtils.isNotEmpty(vo.getRoleName())){
                WHERE("a.role_name like " +ProviderUtil.bindPercent(vo.getRoleName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getRoleCodeOrName())){
                String roleCodeOrName = ProviderUtil.bindPercent(vo.getRoleCodeOrName(), MdmProviderEnum.SQL_JOIN_ALL);
                WHERE("(a.role_name like "+roleCodeOrName+" or a.role_code like "+roleCodeOrName+")");
            }
            if(StringUtils.isNotEmpty(vo.getEnableStatus())){
                WHERE("a.enable_status=#{vo.enableStatus}");
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
            }
            ORDER_BY("a.role_code,a.enable_status desc");
        }}.toString();
    }
}
