package com.biz.crm.role.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.role.mapper.MdmRoleCustomerMapper;
import com.biz.crm.role.mode.MdmRoleCustomerEntity;
import com.biz.crm.role.service.MdmRoleCustomerService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.List;

/**
 * 一个拥有权限信息的业务系统用户定义接口实现
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmRoleCustomerServiceExpandImpl")
@Transactional(rollbackFor = Exception.class)
@Deprecated
public class MdmRoleCustomerServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmRoleCustomerMapper, MdmRoleCustomerEntity> implements MdmRoleCustomerService {


    @Override
    public void addCustomerRole(String customerCode, String roleCode) {
        if (StringUtils.isNotEmpty(customerCode) && StringUtils.isNotEmpty(roleCode)) {
            List<MdmRoleCustomerEntity> list = this.lambdaQuery()
                    .eq(MdmRoleCustomerEntity::getCustomerCode, customerCode)
                    .eq(MdmRoleCustomerEntity::getRoleCode, roleCode)
                    .list();
            if (CollectionUtil.listEmpty(list)) {
                MdmRoleCustomerEntity entity = new MdmRoleCustomerEntity();
                entity.setCustomerCode(customerCode);
                entity.setRoleCode(roleCode);
                this.save(entity);
            }
        }
    }

    @Override
    public void replaceCustomerRole(String customerCode, String roleCode) {
        if (StringUtils.isNotEmpty(customerCode)) {
            this.removeByCustomerCode(customerCode);
            if (StringUtils.isNotEmpty(roleCode)) {
                this.addCustomerRole(customerCode, roleCode);
            }
        }
    }

    @Override
    public void removeByCustomerCode(String customerCode) {
        if (StringUtils.isNotEmpty(customerCode)) {
            this.removeByCustomerCodes(Collections.singletonList(customerCode));
        }
    }

    @Override
    public void removeByCustomerCodes(List<String> customerCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(customerCodes)) {
            this.lambdaUpdate()
                    .in(MdmRoleCustomerEntity::getCustomerCode, customerCodes)
                    .remove();
        }
    }

    @Override
    public void removeByRoleCode(String roleCode) {
        if (StringUtils.isNotEmpty(roleCode)) {
            this.removeByRoleCodes(Collections.singletonList(roleCode));
        }
    }

    @Override
    public void removeByRoleCodes(List<String> roleCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(roleCodes)) {
            this.lambdaUpdate()
                    .in(MdmRoleCustomerEntity::getRoleCode, roleCodes)
                    .remove();
        }
    }
}
