package com.biz.crm.shoppingcart.service;

import com.biz.crm.nebular.mdm.shoppingcart.ShoppingCartVo;

import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/10/20 11:10
 **/
public interface ShoppingCartService {

    /**
     * 加入购物车
     * @param shoppingCartVo
     */
    void add(ShoppingCartVo shoppingCartVo);

    /**
     * 调整购物车商品数量
     * @param shoppingCartVo
     */
    void adjustNum(ShoppingCartVo shoppingCartVo);

    /**
     * 列表查询购物车
     * @param shoppingCartVo
     * @return
     */
    Map<String, List<ShoppingCartVo>> list(ShoppingCartVo shoppingCartVo);

    /**
     * 通过id批量删除购物车
     * @param ids
     */
    void delByIds(List<String> ids, String cusCode);

    /**
     * 批量加入购物车
     * @param shoppingCartVos
     */
    void addBatch(List<ShoppingCartVo> shoppingCartVos);

    /**
     * 清空客户相关商品
     * @param cusCode
     * @param productCodes
     */
    void clearShoppingCar(String cusCode,  List<String> productCodes);

    /**
     * 根据客户编码和商品列表查询
     * @param cusCode
     * @param productCodes
     * @return
     */
    List<ShoppingCartVo> findByCusCodeAndProductCodes(String cusCode, List<String> productCodes);
}
