package com.biz.crm.sync.config;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.nebular.mdm.login.MdmLoginEncryptReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncBaseReqVo;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.util.StringUtils;

import java.util.Optional;

/**
 * 同步配置转换
 *
 * @author zxw
 * @date 2021-05-27 11:43
 **/
public class MdmSyncParameterParser {

    private static final Logger log = LoggerFactory.getLogger(MdmSyncParameterParser.class);

    public static <T> T obtainOriginalData(MdmSyncBaseReqVo mdmSyncBaseReqVo, MdmSyncProperty mdmSyncProperty, String url, Object reqVo, Class<T> cls) {
        String webSiteUrl = mdmSyncBaseReqVo.getUrl();
        if (StringUtils.isEmpty(webSiteUrl)) {
            mdmSyncBaseReqVo.setUrl(mdmSyncProperty.getUrl());
            webSiteUrl = mdmSyncProperty.getUrl();
            mdmSyncBaseReqVo.setUsername(mdmSyncProperty.getUsername());
            mdmSyncBaseReqVo.setPassword(mdmSyncProperty.getPassword());
        }
        if (webSiteUrl.endsWith("/")) {
            webSiteUrl = webSiteUrl.substring(0, webSiteUrl.length()-1);
        }
        //获取token
        MdmLoginEncryptReqVo userReqVo = new MdmLoginEncryptReqVo();
        userReqVo.setUjlrwebjruzddjnu(mdmSyncBaseReqVo.getUsername());
        userReqVo.setPenijmgsbybkfjvr(mdmSyncBaseReqVo.getPassword());
        ResponseEntity<Result<MdmLoginRespVo>> userResponseEntity = RestTemplateUtils.exchange(webSiteUrl + "/mdm/mdmSystemLoginController/login"
                , HttpMethod.POST, null, userReqVo, new ParameterizedTypeReference<Result<MdmLoginRespVo>>() {
                });
        String token = Optional.of(userResponseEntity)
                .map(HttpEntity::getBody)
                .map(Result::getResult)
                .map(MdmLoginRespVo::getLoginUserToken)
                .filter(x -> !StringUtils.isEmpty(x))
                .orElseThrow(() -> new BusinessException("获取用户token失败"));
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("loginUserToken", token);
        httpHeaders.setContentType(MediaType.APPLICATION_JSON_UTF8);
        ResponseEntity<Result<T>> responseEntity = RestTemplateUtils.exchange(webSiteUrl + url
                , HttpMethod.POST, httpHeaders, reqVo, new ParameterizedTypeReference<Result<T>>() {
                });

        return Optional.of(responseEntity)
                .map(HttpEntity::getBody)
                .map(Result::getResult)
                .map(JsonPropertyUtil::toJsonStringNotEmptyVal)
                .map(x->JsonPropertyUtil.toObject(x,cls))
                .orElseThrow(() -> new BusinessException("获取数据失败"));
    }
}
