package com.biz.crm.sync.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.nebular.mdm.sync.MdmSyncDictReqVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncStandardDictReqVo;
import com.biz.crm.sync.service.MdmDictSyncService;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 数据字典同步
 *
 * @author zxw
 * @date 2021-05-28 14:36
 **/
@RestController
@RequestMapping("/mdmDictSyncController")
@CrmGlobalLog
public class MdmDictSyncController {

    @Autowired
    private MdmDictSyncService mdmDictSyncService;

    @ApiOperation("指定环境字典同步")
    @PostMapping("/dictSync")
    public Result<Object> dictSync(@RequestBody MdmSyncDictReqVo mdmSyncDictReqVo) {
        mdmDictSyncService.dictSync(mdmSyncDictReqVo);
        return Result.ok();
    }

    @ApiOperation("标准环境字典同步")
    @PostMapping("/dictBaseSync")
    public Result<Object> dictBaseSync(@RequestBody MdmSyncStandardDictReqVo mdmSyncStandardDictReqVo) {
        MdmSyncDictReqVo mdmSyncDictReqVo = new MdmSyncDictReqVo();
        mdmSyncDictReqVo.setDictTypeCodeList(mdmSyncDictReqVo.getDictTypeCodeList());
        mdmDictSyncService.dictSync(mdmSyncDictReqVo);
        return Result.ok();
    }
}
