package com.biz.crm.sync.controller;

import com.biz.crm.nebular.mdm.sync.MdmSyncBaseReqVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncLogConfigReqVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncLogRespVo;
import com.biz.crm.sync.service.MdmSyncLogConfigService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 日志配置
 *
 * @author zxw
 * @date 2021-06-11 15:48
 **/
@RestController
@RequestMapping("/mdmLogConfigSyncController")
@Api(tags = "MDM-日志配置")
public class MdmLogConfigSyncController {

    @Autowired
    private MdmSyncLogConfigService mdmSyncLogConfigService;

    @ApiOperation("配置查询")
    @PostMapping("/logTemplateList")
    public Result<MdmSyncLogRespVo> logTemplateList(@RequestBody MdmSyncLogConfigReqVo mdmSyncLogConfigReqVo) {
        return Result.ok(mdmSyncLogConfigService.logSync(mdmSyncLogConfigReqVo));
    }

    @ApiOperation("配置模板同步")
    @PostMapping("/logTemplateSync")
    public Result<Object> logTemplateSync(@RequestBody MdmSyncBaseReqVo mdmSyncBaseReqVo){
        mdmSyncLogConfigService.logTemplateSync(mdmSyncBaseReqVo);
        return Result.ok();
    }
}
