package com.biz.crm.sync.service.impl;

import com.biz.crm.annotation.Klock;
import com.biz.crm.dict.model.MdmDictAttrConfEntity;
import com.biz.crm.dict.model.MdmDictDataEntity;
import com.biz.crm.dict.model.MdmDictTypeEntity;
import com.biz.crm.dict.service.MdmDictAttrConfService;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.dict.service.MdmDictTypeService;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictAttrConfRespVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictDataRespVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictTypeRespVo;
import com.biz.crm.nebular.mdm.sync.MdmDictEngineSyncVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncDictReqVo;
import com.biz.crm.sync.config.MdmSyncParameterParser;
import com.biz.crm.sync.config.MdmSyncProperty;
import com.biz.crm.sync.service.MdmDictSyncService;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 数据字典同步配置
 *
 * @author zxw
 * @date 2021-05-28 14:40
 **/
@Service
@Slf4j
@ConditionalOnMissingBean(name = "MdmDictSyncServiceExpandImpl")
public class MdmDictSyncServiceImpl implements MdmDictSyncService {

    @Autowired
    private MdmSyncProperty mdmSyncProperty;
    @Autowired
    private MdmDictTypeService mdmDictTypeService;
    @Autowired
    private MdmDictDataService mdmDictDataService;
    @Autowired
    private MdmDictAttrConfService mdmDictAttrConfService;

    @Override
    @Klock
    public void dictSync(MdmSyncDictReqVo mdmSyncDictReqVo) {
        //获取字典数据
        MdmDictEngineSyncVo mdmDictEngineSyncVo = MdmSyncParameterParser.obtainOriginalData(mdmSyncDictReqVo, mdmSyncProperty
                , "/mdm/mdmdicttype/obtainSyncList", mdmSyncDictReqVo, MdmDictEngineSyncVo.class);

        saveType(mdmSyncDictReqVo, mdmDictEngineSyncVo);
        saveData(mdmSyncDictReqVo, mdmDictEngineSyncVo);
        saveConfig(mdmSyncDictReqVo, mdmDictEngineSyncVo);
        //消除缓存
        mdmDictTypeService.deleteAllCache();
    }

    protected void saveConfig(MdmSyncDictReqVo mdmSyncDictReqVo, MdmDictEngineSyncVo mdmDictEngineSyncVo) {
        List<MdmDictAttrConfRespVo> mdmDictAttrConfRespVoList = mdmDictEngineSyncVo.getMdmDictAttrConfRespVoList();
        if(!CollectionUtils.isEmpty(mdmDictAttrConfRespVoList)){
//            Set<String> configKeyList = mdmDictAttrConfService.lambdaQuery()
//                    .in(!CollectionUtils.isEmpty(mdmSyncDictReqVo.getDictTypeCodeList()), MdmDictAttrConfEntity::getDictTypeCode, mdmSyncDictReqVo.getDictTypeCodeList())
//                    .select(MdmDictAttrConfEntity::getDictTypeCode, MdmDictAttrConfEntity::getFieldCode)
//                    .list()
//                    .stream()
//                    .filter(x -> x != null && !StringUtils.isEmpty(x.getDictTypeCode()) && !StringUtils.isEmpty(x.getFieldCode()))
//                    .map(x -> x.getDictTypeCode() + ":" + x.getFieldCode())
//                    .collect(Collectors.toSet());
//
//            List<MdmDictAttrConfEntity> mdmDictAttrConfEntities = mdmDictAttrConfRespVoList.stream()
//                    .filter(x -> !configKeyList.contains(x.getDictTypeCode() + ":" + x.getFieldCode()))
//                    .map(x -> CrmBeanUtil.copy(x, MdmDictAttrConfEntity.class))
//                    .peek(x -> x.setId(null))
//                    .collect(Collectors.toList());
            List<MdmDictAttrConfEntity> mdmDictAttrConfEntities = CrmBeanUtil.copyList(mdmDictAttrConfRespVoList, MdmDictAttrConfEntity.class);
            if(!CollectionUtils.isEmpty(mdmDictAttrConfEntities)){
                mdmDictAttrConfService.saveOrUpdateBatch(mdmDictAttrConfEntities);
            }
        }
    }

    protected void saveData(MdmSyncDictReqVo mdmSyncDictReqVo, MdmDictEngineSyncVo mdmDictEngineSyncVo) {
        List<MdmDictDataRespVo> mdmDictDataRespVoList = mdmDictEngineSyncVo.getMdmDictDataRespVoList();
        if(!CollectionUtils.isEmpty(mdmDictDataRespVoList)){
//            Set<String> dataKeyList = mdmDictDataService.lambdaQuery()
//                    .in(!CollectionUtils.isEmpty(mdmSyncDictReqVo.getDictTypeCodeList()), MdmDictDataEntity::getDictTypeCode, mdmSyncDictReqVo.getDictTypeCodeList())
//                    .select(MdmDictDataEntity::getDictTypeCode, MdmDictDataEntity::getDictCode)
//                    .list()
//                    .stream()
//                    .filter(x -> x != null && !StringUtils.isEmpty(x.getDictTypeCode()) && !StringUtils.isEmpty(x.getDictCode()))
//                    .map(x -> x.getDictTypeCode() + ":" + x.getDictCode())
//                    .collect(Collectors.toSet());
//            List<MdmDictDataEntity> mdmDictDataEntities = mdmDictDataRespVoList.stream()
//                    .filter(x -> !dataKeyList.contains(x.getDictTypeCode() + ":" + x.getDictCode()))
//                    .map(x -> CrmBeanUtil.copy(x, MdmDictDataEntity.class))
//                    .peek(x -> x.setId(null))
//                    .collect(Collectors.toList());
            List<MdmDictDataEntity> mdmDictDataEntities = CrmBeanUtil.copyList(mdmDictDataRespVoList, MdmDictDataEntity.class);
            if(!CollectionUtils.isEmpty(mdmDictDataEntities)){
                mdmDictDataService.saveOrUpdateBatch(mdmDictDataEntities);
            }
        }
    }

    protected void saveType(MdmSyncDictReqVo mdmSyncDictReqVo, MdmDictEngineSyncVo mdmDictEngineSyncVo) {
        List<MdmDictTypeRespVo> mdmDictTypeRespVoList = mdmDictEngineSyncVo.getMdmDictTypeRespVoList();
        Assert.notEmpty(mdmDictTypeRespVoList, "字典类型查询为空");
//        Set<String> typeKeyList = mdmDictTypeService.lambdaQuery()
//                .in(!CollectionUtils.isEmpty(mdmSyncDictReqVo.getDictTypeCodeList()), MdmDictTypeEntity::getDictTypeCode, mdmSyncDictReqVo.getDictTypeCodeList())
//                .select(MdmDictTypeEntity::getDictTypeCode)
//                .list()
//                .stream()
//                .filter(x -> x != null && !StringUtils.isEmpty(x.getDictTypeCode()))
//                .map(MdmDictTypeEntity::getDictTypeCode)
//                .collect(Collectors.toSet());
//        List<MdmDictTypeEntity> mdmDictTypeEntities = mdmDictTypeRespVoList.stream()
//                .filter(x -> !typeKeyList.contains(x.getDictTypeCode()))
//                .map(x -> CrmBeanUtil.copy(x, MdmDictTypeEntity.class))
//                .peek(x->x.setId(null))
//                .collect(Collectors.toList());
        List<MdmDictTypeEntity> mdmDictTypeEntities = CrmBeanUtil.copyList(mdmDictTypeRespVoList, MdmDictTypeEntity.class);
        if(!CollectionUtils.isEmpty(mdmDictTypeEntities)){
            mdmDictTypeService.saveOrUpdateBatch(mdmDictTypeEntities);
        }
    }
}
