package com.biz.crm.sync.service.impl;

import com.biz.crm.crmlog.template.entity.LogTemplateEntity;
import com.biz.crm.crmlog.template.service.LogTemplateService;
import com.biz.crm.nebular.log.template.LogTemplateVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncBaseReqVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncLogConfigReqVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncLogRespVo;
import com.biz.crm.sync.config.MdmSyncParameterParser;
import com.biz.crm.sync.config.MdmSyncProperty;
import com.biz.crm.sync.service.MdmSyncLogConfigService;
import com.biz.crm.utils.EsBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @author zxw
 * @date 2021-06-11 14:34
 **/
@Service
@Slf4j
@ConditionalOnMissingBean(name = "MdmSyncLogConfigServiceExpandImpl")
public class MdmSyncLogConfigServiceImpl implements MdmSyncLogConfigService {

    @Autowired
    private ElasticsearchRestTemplate elasticsearchRestTemplate;

    @Autowired
    private MdmSyncProperty mdmSyncProperty;

    @Autowired
    private LogTemplateService logTemplateService;

    @Override
    public MdmSyncLogRespVo logSync(MdmSyncLogConfigReqVo mdmSyncLogConfigReqVo) {
        NativeSearchQuery build = EsBuilder.lambdaQuery()
                .withPageable(mdmSyncLogConfigReqVo.getPageNum(), mdmSyncLogConfigReqVo.getPageSize())
                .build();
        List<LogTemplateEntity> entities = elasticsearchRestTemplate.queryForList(build, LogTemplateEntity.class);
        MdmSyncLogRespVo mdmSyncLogRespVo = new MdmSyncLogRespVo();
        if(CollectionUtils.isEmpty(entities)){
            return mdmSyncLogRespVo;
        }
        List<LogTemplateVo> listVo = new ArrayList<>(entities.size());
        for(LogTemplateEntity entity : entities){
            LogTemplateVo logTemplateVo = new LogTemplateVo();
            BeanUtils.copyProperties(entity,logTemplateVo);
            listVo.add(logTemplateVo);
        }
        mdmSyncLogRespVo.setLogTemplateVos(listVo);
        return mdmSyncLogRespVo;
    }

    @Override
    public void logTemplateSync(MdmSyncBaseReqVo mdmSyncBaseReqVo) {
        //同步菜单
        MdmSyncLogRespVo mdmSyncLogRespVo = MdmSyncParameterParser.obtainOriginalData(mdmSyncBaseReqVo, mdmSyncProperty
                , "/mdm/mdmLogConfigSyncController/logTemplateList", mdmSyncBaseReqVo, MdmSyncLogRespVo.class);
        Optional.ofNullable(mdmSyncLogRespVo)
                .map(MdmSyncLogRespVo::getLogTemplateVos)
                .filter(x->!CollectionUtils.isEmpty(x))
                .ifPresent(list->{
                    for (LogTemplateVo logTemplateVo : list) {
                        logTemplateService.add(logTemplateVo);
                    }
                });
    }

}
