package com.biz.crm.sys.index.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.sys.MdmIndexConfigExpandVo;
import com.biz.crm.nebular.mdm.sys.MdmIndexConfigVo;
import com.biz.crm.sys.index.entity.MdmIndexConfigEntity;
import com.biz.crm.sys.index.entity.MdmIndexConfigExpandEntity;
import com.biz.crm.sys.index.mapper.MdmIndexConfigExpandMapper;
import com.biz.crm.sys.index.mapper.MdmIndexConfigMapper;
import com.biz.crm.sys.index.service.MdmIndexConfigExpandService;
import com.biz.crm.sys.index.service.MdmIndexConfigService;
import com.biz.crm.sys.index.vo.MdmIndexConfigStopOrOpenOrDeleteVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.sys.index.service
 * @Description: TODO
 * @date 2020/11/24 下午12:58
 */
@Service
@Transactional
public class MdmIndexConfigServiceImpl extends ServiceImpl<MdmIndexConfigMapper, MdmIndexConfigEntity> implements MdmIndexConfigService {
    @Resource
    private MdmIndexConfigMapper mdmIndexConfigMapper;
    @Resource
    private MdmIndexConfigExpandMapper mdmIndexConfigExpandMapper;
    @Autowired
    private MdmIndexConfigExpandService mdmIndexConfigExpandService;

    @Override
    public PageResult<MdmIndexConfigVo> findList(MdmIndexConfigVo vo) {
        Page<MdmIndexConfigVo> page = new Page<>(vo.getPageNum(), vo.getPageSize());
        List<MdmIndexConfigVo> list = mdmIndexConfigMapper.findList(page, vo);
        if(!CollectionUtils.isEmpty(list)){
            for (MdmIndexConfigVo mdmIndexConfigVo : list) {
                String id = mdmIndexConfigVo.getId();
                if(!StringUtils.isEmpty(id)){
                    QueryWrapper<MdmIndexConfigExpandEntity> queryWrapper = new QueryWrapper<>();
                    queryWrapper.eq("config_id", id);
                    List<MdmIndexConfigExpandEntity> mdmIndexConfigExpandEntities = mdmIndexConfigExpandMapper.selectList(queryWrapper);
                    List<MdmIndexConfigExpandVo> items = CrmBeanUtil.copyList(mdmIndexConfigExpandEntities, MdmIndexConfigExpandVo.class);
                    mdmIndexConfigVo.setItems(items);
                }
            }
        }
        return PageResult.<MdmIndexConfigVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public void stopOrOpen(MdmIndexConfigStopOrOpenOrDeleteVo vo) {
        if (CollectionUtil.listEmpty(vo.getIds())) {
            throw new BusinessException("请选择数据");
        }
        for (String id : vo.getIds()) {
            MdmIndexConfigEntity entity = this.getById(id);
            if (entity!=null) {
                entity.setEnableStatus(vo.getEnableStatus());
                this.updateById(entity);
            }
        }
    }

    @Override
    public void delete(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("请选择数据");
        }
        mdmIndexConfigMapper.deleteBatchIds(ids);
        QueryWrapper<MdmIndexConfigExpandEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("config_id", ids);
        mdmIndexConfigExpandMapper.delete(queryWrapper);
    }

    @Override
    public MdmIndexConfigVo detail(String id) {
        MdmIndexConfigEntity entity = this.getById(id);
        MdmIndexConfigVo mdmIndexConfigVo = new MdmIndexConfigVo();
        BeanUtils.copyProperties(entity, mdmIndexConfigVo);
        QueryWrapper<MdmIndexConfigExpandEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("config_id", id);
        List<MdmIndexConfigExpandEntity> mdmIndexConfigExpandEntities = mdmIndexConfigExpandMapper.selectList(queryWrapper);
        if (CollectionUtil.listEmpty(mdmIndexConfigExpandEntities)) {
            mdmIndexConfigExpandEntities = new ArrayList<>();
        }
        List<MdmIndexConfigExpandVo> items = CrmBeanUtil.copyList(mdmIndexConfigExpandEntities, MdmIndexConfigExpandVo.class);
        mdmIndexConfigVo.setItems(items);
        return mdmIndexConfigVo;
    }

    @Override
    public void saveOrUpdateEntity(MdmIndexConfigVo vo) {
        List<MdmIndexConfigExpandVo> items = vo.getItems();
        items = CollectionUtil.listEmpty(items)?new ArrayList<>():items;
        if (StringUtils.isEmpty(vo.getId())) {
            MdmIndexConfigEntity mdmIndexConfigEntity = new MdmIndexConfigEntity();
            BeanUtils.copyProperties(vo, mdmIndexConfigEntity);
            this.save(mdmIndexConfigEntity);
            List<MdmIndexConfigExpandEntity> eneititems = CrmBeanUtil.copyList(items, MdmIndexConfigExpandEntity.class);
            for (MdmIndexConfigExpandEntity eneititem : eneititems) {
                eneititem.setConfigId(mdmIndexConfigEntity.getId());
            }
            mdmIndexConfigExpandService.saveBatch(eneititems);
        }else {
            MdmIndexConfigEntity mdmIndexConfigEntity = this.getById(vo.getId());
            BeanUtils.copyProperties(vo, mdmIndexConfigEntity);
            this.updateById(mdmIndexConfigEntity);
            QueryWrapper<MdmIndexConfigExpandEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("config_id", vo.getId());
            mdmIndexConfigExpandMapper.delete(queryWrapper);
            List<MdmIndexConfigExpandEntity> eneititems = CrmBeanUtil.copyList(items, MdmIndexConfigExpandEntity.class);
            for (MdmIndexConfigExpandEntity eneititem : eneititems) {
                eneititem.setConfigId(vo.getId());
            }
            mdmIndexConfigExpandService.saveBatch(eneititems);
        }
    }
}
