package com.biz.crm.tableconfig.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.ClassUtil;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.pageconfig.*;
import com.biz.crm.tableconfig.service.IMdmColumnConfigService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 字段配置
 *
 * @author zxw
 * @date 2020-11-21 12:19:06
 */
@Slf4j
@RestController
@RequestMapping("/mdmcolumnconfig")
@Api(tags = "字段配置")
@PropertySource("classpath:bootstrap.yml")//读取application.yml文件
public class MdmColumnConfigController {
    @Autowired
    private IMdmColumnConfigService mdmColumnConfigService;

    //获取项目端口号
    @Value("${vopackagepath:com.biz.crm}")
    private String voPackagePath;

    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<MdmColumnConfigRespVo>> list(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        return Result.ok(mdmColumnConfigService.findList(mdmColumnConfigReqVo));
    }

    @ApiOperation("字段配置列表")
    @PostMapping("/list_condition")
    public Result<List<MdmColumnConfigRespVo>> listCondition(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        return Result.ok(mdmColumnConfigService.listCondition(mdmColumnConfigReqVo));
    }

    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<MdmColumnConfigRespVo> query(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        MdmColumnConfigRespVo respVo = mdmColumnConfigService.query(mdmColumnConfigReqVo);
        return Result.ok(respVo);
    }

    @ApiOperation("批量新增")
    @PostMapping("/save_batch")
    public Result<Object> saveBatch(@RequestBody MdmColumnConfigBatchReqVo mdmColumnConfigBatchReqVo) {
        mdmColumnConfigService.addBatch(mdmColumnConfigBatchReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result<Object> save(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        mdmColumnConfigService.save(mdmColumnConfigReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result<Object> update(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        mdmColumnConfigService.update(mdmColumnConfigReqVo);
        return Result.ok("修改成功");
    }

    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result<Object> delete(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        mdmColumnConfigService.deleteBatch(mdmColumnConfigReqVo);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result<Object> enable(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        mdmColumnConfigService.enableBatch(mdmColumnConfigReqVo);
        return Result.ok("启用成功");
    }

    @ApiOperation("根据类全路径名获取字段解析")
    @GetMapping("/column_resolve")
    public Result<List<MdmColumnConfigRespVo>> columnResolve(@RequestParam("classPath") String classPath) {
        return Result.ok(mdmColumnConfigService.columnResolve(classPath));
    }

    @ApiOperation("获取配置vo")
    @PostMapping("/column_resolve_select")
    public Result<List<MdmColumnResolveVo>> columnResolveSelect(@RequestBody MdmColumnResolveVo mdmColumnResolveVo) {
        List<Class<?>> classes = new ArrayList<>(500);
        String[] pageagePath = voPackagePath.split(",");
        for(String path : pageagePath){
            List<Class<?>> currentClasses = ClassUtil.getClasses(path);
            if(!CollectionUtils.isEmpty(currentClasses)){
                classes.addAll(currentClasses);
            }
        }
        List<MdmColumnResolveVo> collect = classes.stream()
                .filter(x -> x.isAnnotationPresent(CrmColumnResolve.class))
                .filter(x-> StringUtils.isEmpty(mdmColumnResolveVo.getClassName())||x.getSimpleName().contains(mdmColumnResolveVo.getClassName()))
                .map(x -> {
                    MdmColumnResolveVo mdmColumnResolveVo1 = new MdmColumnResolveVo();
                    ApiModel annotation = x.getAnnotation(ApiModel.class);
                    if (annotation != null) {
                        mdmColumnResolveVo1.setClassNote(annotation.value());
                    }
                    mdmColumnResolveVo1.setClassName(x.getSimpleName());
                    mdmColumnResolveVo1.setClassPath(x.getName());
                    return mdmColumnResolveVo1;
                })
                .collect(Collectors.toList());
        return Result.ok(collect);
    }

    @ApiOperation("字段下拉框")
    @PostMapping("/columnSelect")
    public Result<List<MdmColumnExportRespVo>> columnSelect(@RequestBody MdmColumnConfigReqVo mdmColumnConfigReqVo) {
        List<MdmColumnExportRespVo> list = mdmColumnConfigService.columnSelect(mdmColumnConfigReqVo);
        return Result.ok(list);
    }
}
