package com.biz.crm.tableconfig.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.pageconfig.*;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSubButtonReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSubButtonVo;
import com.biz.crm.tableconfig.model.MdmFunctionSubEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 下级菜单表
 *
 * @author zxw
 * @date 2020-11-21 00:22:17
 */
public interface MdmFunctionSubMapper extends BaseMapper<MdmFunctionSubEntity> {
    /**
     * 列表
     *
     * @param page
     * @param mdmFunctionSubReqVo
     * @return
     */
    List<MdmFunctionSubRespVo> findList(Page<MdmFunctionSubRespVo> page, @Param("vo") MdmFunctionSubReqVo mdmFunctionSubReqVo);

    /**
     * 功能列表按钮查询
     * @param mdmFunctionSubButtonReqVo vo
     * @return list
     */
    List<MdmButtonConfigRespVo> buttonList(@Param("vo") MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo);

    /**
     * 功能列表查询按钮
     * @param id id
     * @return
     */
    MdmButtonConfigRespVo buttonQuery(@Param("id") String id);

    /**
     * 根据菜单与功能编码查询按钮名称集合
     * @param mdmRoleSubButtonReqVo vo
     * @return list
     */
    List<MdmRoleSubButtonVo> buttonSelectList(@Param("vo") MdmRoleSubButtonReqVo mdmRoleSubButtonReqVo);

    /**
     * 条件查询功能列表
     * @param mdmFunctionSubReqVo vo
     * @return list
     */
    List<MdmFunctionSubRespVo> findSubList(@Param("vo") MdmFunctionSubReqVo mdmFunctionSubReqVo);


    /**
     * 根据上级菜单查询配置权限的功能列表(数据权限专用)
     * @param mdmFunctionSubReqVo vo
     * @return list
     */
    List<MdmFunctionSubPermissionVo> findAuthorizedSubList(@Param("vo") MdmFunctionSubReqVo mdmFunctionSubReqVo);
}
