package com.biz.crm.tableconfig.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigBatchReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.tableconfig.model.MdmColumnConfigEntity;

import java.util.List;

/**
 * 字段配置接口
 *
 * @author zxw
 * @date 2020-11-21 12:19:06
 */
public interface IMdmColumnConfigService extends IService<MdmColumnConfigEntity> {

    /**
     * 列表
     *
     * @param mdmColumnConfigReqVo
     * @return PageResult<MdmColumnConfigRespVo>
     */
    PageResult<MdmColumnConfigRespVo> findList(MdmColumnConfigReqVo mdmColumnConfigReqVo);

    /**
     * 查询
     *
     * @param mdmColumnConfigReqVo
     * @return MdmColumnConfigRespVo
     */
    MdmColumnConfigRespVo query(MdmColumnConfigReqVo mdmColumnConfigReqVo);

    /**
     * 新增
     *
     * @param mdmColumnConfigReqVo
     * @return
     */
    void save(MdmColumnConfigReqVo mdmColumnConfigReqVo);

    /**
     * 更新
     *
     * @param mdmColumnConfigReqVo
     * @return
     */
    void update(MdmColumnConfigReqVo mdmColumnConfigReqVo);

    /**
     * 删除
     *
     * @param mdmColumnConfigReqVo
     * @return
     */
    void deleteBatch(MdmColumnConfigReqVo mdmColumnConfigReqVo);

    /**
     * 启用
     *
     * @param mdmColumnConfigReqVo
     * @return
     */
    void enableBatch(MdmColumnConfigReqVo mdmColumnConfigReqVo);

    /**
     * 禁用
     *
     * @param mdmColumnConfigReqVo
     * @return
     */
    void disableBatch(MdmColumnConfigReqVo mdmColumnConfigReqVo);

    /**
     * 条件查询
     *
     * @param mdmColumnConfigReqVo
     * @return
     */
    List<MdmColumnConfigRespVo> listCondition(MdmColumnConfigReqVo mdmColumnConfigReqVo);

    /**
     * 字段解析
     *
     * @param classPath
     * @return
     */
    List<MdmColumnConfigRespVo> columnResolve(String classPath);

    /**
     * 批量新增
     *
     * @param mdmColumnConfigBatchReqVo vo
     */
    void addBatch(MdmColumnConfigBatchReqVo mdmColumnConfigBatchReqVo);

    /**
     * 字段下拉框
     *
     * @param mdmColumnConfigReqVo vo
     * @return list
     */
    List<MdmColumnExportRespVo> columnSelect(MdmColumnConfigReqVo mdmColumnConfigReqVo);
}

