package com.biz.crm.tableconfig.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.pageconfig.*;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSubButtonReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSubButtonVo;
import com.biz.crm.nebular.mdm.role.req.MdmSwitchFunctionButtonReqVo;
import com.biz.crm.tableconfig.model.MdmFunctionSubButtonEntity;
import com.fasterxml.jackson.databind.JsonNode;

import java.util.List;

/**
 * 功能列表与按钮关联表接口
 *
 * @author zxw
 * @date 2020-12-05 12:56:52
 */
public interface IMdmFunctionSubButtonService extends IService<MdmFunctionSubButtonEntity> {

    /**
     * 分页查询
     * @param mdmFunctionSubButtonReqVo vo
     * @return page
     */
    PageResult<MdmFunctionSubButtonRespVo> findList(MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo);

    PageResult<JsonNode> dynamicExportSearch(MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo);

    List<MdmColumnExportRespVo> dynamicExportResolve(MdmColumnConfigReqVo mdmColumnConfigReqVo);

    /**
     * 功能列表设置按钮
     *
     * @param mdmFunctionSubButtonReqVo vo
     */
    void setUp(MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo);

    /**
     * 功能列表查询按钮
     *
     * @param mdmFunctionSubButtonReqVo   vo
     * @return list
     */
    List<MdmButtonConfigRespVo> buttonList(MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo);

    /**
     * 功能列表按钮删除
     * @param ids id集合
     */
    void buttonRemove(List<String> ids);

    /**
     * 功能列表查询按钮
     * @param id id
     * @return
     */
    MdmButtonConfigRespVo buttonQuery(String id);

    /**
     * 角色关联可展示的按钮
     * @param mdmRoleSubButtonReqVo vo
     * @return list
     */
    List<MdmRoleSubButtonVo> buttonList(MdmRoleSubButtonReqVo mdmRoleSubButtonReqVo);

    /**
     * 切换当前及下级菜单关联按钮状态
     * @param mdmSwitchFunctionButtonReqVo vo
     */
    void switchFunctionButton(MdmSwitchFunctionButtonReqVo mdmSwitchFunctionButtonReqVo);

}

