package com.biz.crm.tableconfig.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.pageconfig.MdmFormConfigReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFormConfigRespVo;
import com.biz.crm.tableconfig.mapper.MdmFormConfigMapper;
import com.biz.crm.tableconfig.model.MdmFormConfigEntity;
import com.biz.crm.tableconfig.service.IMdmFormConfigService;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * 表单配置接口实现
 *
 * @author zxw
 * @date 2020-11-21 15:51:27
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmFormConfigServiceExpandImpl")
public class MdmFormConfigServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmFormConfigMapper, MdmFormConfigEntity> implements IMdmFormConfigService {

    @Resource
    private MdmFormConfigMapper mdmFormConfigMapper;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<MdmFormConfigRespVo> findList(MdmFormConfigReqVo reqVo) {
        Page<MdmFormConfigRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<MdmFormConfigRespVo> list = mdmFormConfigMapper.findList(page, reqVo);
        return PageResult.<MdmFormConfigRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return mdmFormConfigRespVo
     */
    @Override
    public MdmFormConfigRespVo query(MdmFormConfigReqVo reqVo) {
        MdmFormConfigEntity one = this.lambdaQuery()
                .eq(!StringUtils.isEmpty(reqVo.getId()), MdmFormConfigEntity::getId, reqVo.getId())
                .eq(!StringUtils.isEmpty(reqVo.getFunctionCode()), MdmFormConfigEntity::getFunctionCode, reqVo.getFunctionCode())
                .one();
        return CrmBeanUtil.copy(one, MdmFormConfigRespVo.class);
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(MdmFormConfigReqVo reqVo) {
        MdmFormConfigEntity entity = CrmBeanUtil.copy(reqVo, MdmFormConfigEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(MdmFormConfigReqVo reqVo) {
        MdmFormConfigEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(MdmFormConfigReqVo reqVo) {
        this.lambdaUpdate()
                .in(!CollectionUtils.isEmpty(reqVo.getIds()), MdmFormConfigEntity::getId, reqVo.getId())
                .remove();
    }

    @Override
    public List<MdmFormConfigRespVo> listCondition(MdmFormConfigReqVo mdmFormConfigReqVo) {
        List<MdmFormConfigEntity> one = this.lambdaQuery()
                .eq(!StringUtils.isEmpty(mdmFormConfigReqVo.getFunctionCode()), MdmFormConfigEntity::getFunctionCode, mdmFormConfigReqVo.getFunctionCode())
                .list();
        return CrmBeanUtil.copyList(one, MdmFormConfigRespVo.class);
    }

}
