package com.biz.crm.terminal.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.terminal.service.MdmTerminalElasticsearchService;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalCustomerElasticsearchPageReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalCustomerElasticsearchRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author ql
 * @date 2021/3/10
 * @time 10:00
 **/
@Slf4j
@RestController
@RequestMapping("/MdmTerminalCustomerElasticsearchController")
@Api(tags = "客户和终端Elasticsearch")
@CrmGlobalLog
public class MdmTerminalCustomerElasticsearchController {

    @Autowired
    private MdmTerminalElasticsearchService mdmTerminalElasticsearchService;

    @ApiOperation(value = "分页查询")
    @PostMapping("/list")
    @CrmDictMethod
    public Result<PageResult<MdmTerminalCustomerElasticsearchRespVo>> list(
            @RequestBody MdmTerminalCustomerElasticsearchPageReqVo pageReqVo) {
        PageResult<MdmTerminalCustomerElasticsearchRespVo> result = mdmTerminalElasticsearchService.listWithPage(pageReqVo);
        return Result.ok(result);
    }

}
