package com.biz.crm.terminal.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalFormReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalFormRespVo;
import com.biz.crm.terminal.service.MdmTerminalFormService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author hx
 * @ClassName MdmTerminalFormController
 * @Description 终端汇总报表controller
 * @date 2022/03/30
 */
@Slf4j
@RestController
@RequestMapping("/mdmTerminalFormController")
@Api(tags = "终端汇总报表")
@CrmGlobalLog
public class MdmTerminalFormController {

    @Autowired
    private MdmTerminalFormService mdmTerminalFormService;

    @ApiOperation(value = "终端汇总分页查询")
    @PostMapping("/pageList")
    @CrmDictMethod
    public Result<PageResult<MdmTerminalFormRespVo>> pageList(@RequestBody MdmTerminalFormReqVo reqVo) {
        PageResult<MdmTerminalFormRespVo> result = mdmTerminalFormService.findList(reqVo);
        return Result.ok(result);
    }
}
