package com.biz.crm.terminal.controller;

import com.biz.crm.nebular.mdm.customer.MdmCustomerRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalSupplyDetailVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.terminal.model.MdmTerminalSupplyDetailEntity;
import com.biz.crm.terminal.service.MdmTerminalSupplyDetailService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Project crm
 * @PackageName com.biz.crm.terminal.controller
 * @ClassName MdmTerminalSupplyController
 * @Author Gavin
 * @Date 2021/6/3 下午2:36
 * @Description
 */
@Slf4j
@RestController
@RequestMapping("/mdmTerminalSupplyController")
@Api(tags = "终端供货关系")
public class MdmTerminalSupplyController {

  @Resource
  private MdmTerminalSupplyService mdmTerminalSupplyService;


  /**
   * 通过终端门店编码查询挂靠的客户信息
   */
  @ApiOperation(value = "通过终端门店编码查询挂靠的客户信息")
  @PostMapping("/findBySupply")
  public Result<List<MdmCustomerRespVo>> findBySupply(@RequestBody MdmTerminalSupplyVo mdmTerminalSupplyVo) {
    List<MdmCustomerRespVo> respVos = mdmTerminalSupplyService.findBySupply(mdmTerminalSupplyVo);
    return Result.ok(respVos);
  }

  /**
   * 通过供应关系id查询商品层级信息
   */
  @ApiOperation(value = "通过供应关系id查询商品层级信息")
  @GetMapping("/findGoodsLevelBySupplyId")
  public Result<List<MdmTerminalSupplyDetailEntity>> findGoodsLevelBySupplyId(@RequestParam(value = "supplyId") String supplyId, @RequestParam(value = "dataType", required = false) String dataType) {
    List<MdmTerminalSupplyDetailEntity> respVos = mdmTerminalSupplyService.findGoodsLevelBySupplyId(supplyId,dataType);
    return Result.ok(respVos);
  }
}