package com.biz.crm.terminal.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.eunm.upload.UploadEnum.userName;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapDistrictStatisticianRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeVo;
import com.biz.crm.nebular.mdm.terminal.*;
import com.biz.crm.nebular.mdm.terminal.req.MdmAmapDistrictStatisticianReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalSelectReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalSelectRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaTPMTerminalReqVo;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.provider.MdmTerminalProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * @author Liao.Hua
 * @date 2020-09-01 14:13:56
 */
public interface MdmTerminalMapper extends BaseMapper<MdmTerminalEntity> {
    /**
     * 列表
     *
     * @param page             page
     * @param mdmTerminalReqVo vo
     * @return list
     */
    @SqlPrivilege(
            extCustSql = "a.terminal_code in(select terminal_code from mdm_terminal_supply where customer_code in )",
            inOrgSql = "a.terminal_code in(select terminal_code from mdm_terminal_r_org where org_code in )",
            inPositionSql = "a.terminal_code in(select terminal_code from mdm_terminal_supply where position_code in )"
    )
    List<MdmTerminalVo> findList(Page<MdmTerminalVo> page, @Param("vo") MdmTerminalVo mdmTerminalReqVo);

    /**
     * 列表(provider)
     *
     * @param page             page
     * @param mdmTerminalReqVo vo
     * @return list
     */
    @SelectProvider(type = MdmTerminalProvider.class, method = "findList")
    List<MdmTerminalVo> findListProvider(Page<MdmTerminalVo> page, @Param("vo") MdmTerminalVo mdmTerminalReqVo);


    /**
     * 查询当前及下级组织的终端集合
     *
     * @return list
     */
    @Deprecated
    List<MdmTerminalVo> findCurrentAndSubTerminalList(@Param("orgCodes") List<String> orgCodes);

    /**
     * 根据职位编码或id查询终端列表
     *
     * @return list
     */
    List<MdmTerminalVo> findPositionTerminalList(@Param("posId") String posId, @Param("posCode") String posCode);

    List<MdmTerminalVo> findPositionsTerminalList(@Param("posCodes") List<String> posCodes);

    /**
     * 终端及主联系人分页查询
     *
     * @param page                        page
     * @param mdmTerminalContactPageReqVo vo
     * @return list
     */
    @SqlPrivilege(
            extCustSql = "a.terminal_code in(select terminal_code from mdm_terminal_supply where customer_code in )",
            inOrgSql = "a.terminal_code in(select terminal_code from mdm_terminal_r_org where org_code in )",
            inPositionSql = "a.terminal_code in(select terminal_code from mdm_terminal_supply where position_code in )"
    )
    List<MdmTerminalContactPageVo> userTerminalContactPage(Page<MdmTerminalContactPageVo> page, @Param("vo") MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo);

    /**
     * 根据座标距离分页
     *
     * @param page                        page
     * @param mdmTerminalContactPageReqVo vo
     * @return page
     */
    List<MdmTerminalContactPageVo> distancePage(Page<MdmTerminalContactPageVo> page, @Param("vo") MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo);

    /**
     * 根据id或终端编码查询详情
     *
     * @param id           id
     * @param terminalCode 终端编码
     * @return vo
     */
    MdmTerminalVo query(@Param("id") String id, @Param("terminalCode") String terminalCode);

    /**
     * 根据客户编码或组织编码查询终端信息
     *
     * @param page                  page
     * @param mdmCustomerTerminalVo vo
     * @return list
     */
    List<MdmTerminalVo> customerTerminalList(Page<MdmTerminalVo> page, @Param("vo") MdmCustomerTerminalVo mdmCustomerTerminalVo);

    /**
     * 根据营业注册号或终端名称查询详情
     *
     * @param licenseRegisterNumber 营业注册吗
     * @param terminalName          终端名称
     * @return 详情
     */
    MdmTerminalVo findDetailByRegisterOrName(@Param("licenseRegisterNumber") String licenseRegisterNumber, @Param("terminalName") String terminalName);

    /**
     * 条件查询终端主联系人及距离分页列表
     *
     * @param page                                page
     * @param mdmTerminalDistanceContactPageReqVo vo
     * @return list
     */
    @SqlPrivilege(
            extCustSql = "a.terminal_code in(select terminal_code from mdm_terminal_supply where customer_code in )",
            inOrgSql = "a.terminal_code in(select terminal_code from mdm_terminal_r_org where org_code in )",
            inPositionSql = "a.terminal_code in(select terminal_code from mdm_terminal_supply where position_code in )"
    )
    List<MdmTerminalContactPageVo> distanceContactPage(Page<MdmTerminalContactPageVo> page, @Param("vo") MdmTerminalDistanceContactPageReqVo mdmTerminalDistanceContactPageReqVo);

    /**
     * 终端下拉框
     *
     * @param reqVo
     * @param includeList 只查询这些编码
     * @param excludeList 排除这些编码
     * @return
     */
    @SqlPrivilege(
            extPosSql = "select 1 from mdm_terminal_supply where terminal_code=a.terminal_code and position_code in",
            extOrgSql = "select 1 from mdm_terminal_r_org where terminal_code=a.terminal_code and org_code in"
    )
    List<MdmTerminalSelectRespVo> findTerminalSelectList(Page<MdmTerminalSelectRespVo> page, @Param("vo") MdmTerminalSelectReqVo reqVo, @Param("includeList") List<String> includeList, @Param("excludeList") List<String> excludeList);

    /**
     * 条件查询
     *
     * @param mdmTerminalReqVo
     * @param page
     * @return
     */
    List<MdmTerminalVo> listCondition(@Param("vo") MdmTerminalVo mdmTerminalReqVo, Page<MdmTerminalVo> page);

    /**
     * 条件查询终端及主联系人列表
     *
     * @param page                       page
     * @param mdmTerminalCurrentAndSubVo vo
     * @return list
     */
    @SqlPrivilege(
            extCustSql = "a.terminal_code in(select terminal_code from mdm_terminal_supply where customer_code in )",
            inOrgSql = "a.terminal_code in(select terminal_code from mdm_terminal_r_org where org_code in )",
            inPositionSql = "a.terminal_code in(select terminal_code from mdm_terminal_supply where position_code in )"
    )
    List<MdmTerminalContactPageVo> findTerminalAndContactList(Page<MdmTerminalVo> page, @Param("vo") MdmTerminalCurrentAndSubVo mdmTerminalCurrentAndSubVo);

    /**
     * 根据职位编码查询对接终端数
     *
     * @param positionCode 职位编码
     * @param dateTime
     * @return
     */
    Long countTerminalByPosition(@Param("positionCode") String positionCode, @Param("dateTime") String dateTime, @Param("actApproveStatus") String actApproveStatus);

    List<MdmTerminalStatisticianTypeVo> statisticalType(@Param("vo") MdmTerminalVo mdmTerminalVo);

    /**
     * 终端省统计
     * @param mdmAmapDistrictStatisticianReqVo vo
     * @return list
     */
    List<MdmAmapDistrictStatisticianRespVo> statisticalProvince(@Param("vo") MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo);

    /**
     * 终端市统计
     * @param mdmAmapDistrictStatisticianReqVo vo
     * @return list
     */
    List<MdmAmapDistrictStatisticianRespVo> statisticalCity(@Param("vo") MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo);

    List<MdmAmapDistrictStatisticianRespVo> statisticalDistrict(@Param("vo") MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo);

    /**
     * 根据名称和地址查询终端详情
     * @param terminalName  终端名称
     * @param terminalAddress 终端地址
     * @return MdmTerminalVo 终端
     */
    MdmTerminalVo findTerminalByNameOrAddress(@Param("terminalName") String terminalName,@Param("terminalAddress") String terminalAddress);

    /**
     * 通过用户登录编码查询终端信息
     * @param userName
     * @return
    */
  List<MdmTerminalVo> findTerminalByUserName(@Param("userName")String userName);

    /**
     * 通过主联系人电话,获取终端信息
     *
     * @param contactPhone 主联系人电话
     * @return 终端信息
     */
    List<MdmTerminalVo> findTerminalByMainContactPhone(@Param("contactPhone")String contactPhone);

    /**
     * 通过组织编码集合和条件获取终端信息
     *
     */
    List<MdmTerminalVo> selectTerminalByOrgCodeList(@Param("vo")SfaTPMTerminalReqVo vo);
}
