package com.biz.crm.terminal.provider;


import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.Map;

/**
 * @Author hej
 * @Created Date 2020-12-28
 **/
public class MdmTerminalProvider {


    /**
     * 列表selectProvider
     *
     * @param map
     * @return
     */
    public String findList(Map<String,Object> map) {
        MdmTerminalVo vo = (MdmTerminalVo) map.get("vo");
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL() {{
            SELECT("a.*,c.customer_org_name");
            FROM("mdm_terminal a");
            LEFT_OUTER_JOIN(" mdm_cus_org c on c.customer_org_code=a.customer_org_code");
            if (StringUtils.isNotEmpty(vo.getTerminalCode())) {
                WHERE("a.terminal_code like "+ProviderUtil.bindPercent(vo.getTerminalCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getTerminalName())) {
                WHERE("a.terminal_name like "+ProviderUtil.bindPercent(vo.getTerminalName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (StringUtils.isNotEmpty(vo.getCustomerOrgCode())) {
                WHERE("a.customer_org_code "+ProviderUtil.bindPercent(vo.getCustomerOrgCode(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(vo.getTerminalCodeList())) {
                WHERE("terminal_code in " + ProviderUtil.gainForeach("(", ",", ")", vo.getTerminalCodeList()));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
            }
            ORDER_BY("a.create_date desc,a.create_date_second desc");
        }}.toString();
    }


}
