package com.biz.crm.terminal.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.terminal.model.MdmTerminalContactEntity;

import java.util.List;

/**
 * 联系人接口
 *
 * @author liaohua
 * @date 2020-09-02 14:10:26
 */
public interface MdmTerminalContactService extends IService<MdmTerminalContactEntity> {

    /**
     * 批量删除
     *
     * @param terminalCodes 终端编码集合
     */
    void deleteByCodes(List<String> terminalCodes);

    /**
     * 更新终端联系人
     *
     * @param mdmTerminalVo vo
     */
    void setUpContact(MdmTerminalVo mdmTerminalVo);

    /**
     * 根据终端编码查询联系人
     * @param terminalCode 终端编码
     * @return list
     */
    List<MdmTerminalContactVo> findByTerminalCode(String terminalCode);
}
