package com.biz.crm.terminal.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeVo;
import com.biz.crm.nebular.mdm.terminal.*;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalSelectReqVo;
import com.biz.crm.nebular.mdm.terminal.req.UpdateCoordinateReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalSelectRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaTPMTerminalReqVo;
import com.biz.crm.nebular.sfa.tpmact.SfaTpmOrgRCusVo;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.nebular.mdm.terminal.MdmTencentMapData;
import com.biz.crm.terminal.vo.UpdateTerminalCusOrgCodeVo;

import java.util.List;
import java.util.Map;

/**
 * 接口
 *
 * @author Liao.Hua
 * @date 2020-09-01 17:47:01
 */
public interface MdmTerminalService extends IService<MdmTerminalEntity> {
    /**
     * 列表
     *
     * @param mdmTerminalReqVo vo
     * @return PageResult
     */
    PageResult<MdmTerminalVo> findList(MdmTerminalVo mdmTerminalReqVo);

    /**
     * 查询
     *
     * @return MdmTerminalRespVo
     */
    MdmTerminalVo query(String id, String terminalCode);

    /**
     * 根据终端编码查询终端主表
     *
     * @param terminalCode 终端编码
     * @return vo
     */
    MdmTerminalVo queryByTerminalCode(String terminalCode);

    /**
     * 根据终端编码集合批量查询终端主表信息
     *
     * @param terminalCodeList list
     * @return list
     */
    List<MdmTerminalVo> queryBatchByTerminalCodeList(List<String> terminalCodeList);

    /**
     * 新增
     *
     * @param mdmTerminalVo vo
     * @return code
     */
    String save(MdmTerminalVo mdmTerminalVo);

    /**
     * 批量新增（只适用于腾讯地图终端数据同步
     * @param mdmTencentMapData
     */
    void saveTxBatch(MdmTencentMapData mdmTencentMapData);

    /**
     * 新增并提交流程
     *
     * @param mdmTerminalVo vo
     * @return code
     */
    String saveAndSubmit(MdmTerminalVo mdmTerminalVo);

    /**
     * 从sfa新增终端参数重复性校验
     *
     * @param reqVo reqVo
     */
    String validateSaveParamFromSfa(MdmTerminalVo reqVo);

    /**
     * 更新
     *
     * @param mdmTerminalVo vo
     */
    void update(MdmTerminalVo mdmTerminalVo);

    /**
     * 根据客户编码集合修改经纬度
     *
     * @param updateCoordinateReqVos
     */
    void updateCoordinate(List<UpdateCoordinateReqVo> updateCoordinateReqVos);

    /**
     * 更新并提交
     *
     * @param mdmTerminalVo
     */
    void updateAndSubmit(MdmTerminalVo mdmTerminalVo);

    /**
     * 删除
     *
     * @param ids ids
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids ids
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids ids
     */
    void disableBatch(List<String> ids);


    /**
     * 更新客户组织编码
     */
    void updateCusOrgCode(UpdateTerminalCusOrgCodeVo vo);

    /**
     * 根据组织编码集合查询终端编码集合
     *
     * @param list 组织编码集合
     * @return result
     */
    List<String> findByOrgCodeList(List<String> list);

    /**
     * 根据终端code集合查询终端编码名称map
     *
     * @param terminalCodeList list
     * @return map
     */
    Map<String, String> getTerminalCodeNameMap(List<String> terminalCodeList);

    /**
     * 根据终端code集合批量查询终端的组织编码
     *
     * @param terminalCodeList 终端编码集合
     * @return result
     */
    Map<String, String> findOrgCodeByTerminalCodeList(List<String> terminalCodeList);

    /**
     * 根据终端code集合批量查询终端的组织集合
     *
     * @param terminalCodeList 终端编码集合
     * @return result
     */
    Map<String, List<String>> findOrgCodeListByTerminalCodeList(List<String> terminalCodeList);


    /**
     * 根据组织编码查询当前及下级终端
     *
     * @param orgCodes privilege
     * @return list
     */
    List<MdmTerminalVo> findCurrentAndSubTerminalList(List<String> orgCodes);

    /**
     * 条件列表查询
     *
     * @param mdmTerminalReqVo privilege
     * @return list
     */
    List<MdmTerminalVo> listCondition(MdmTerminalVo mdmTerminalReqVo);

    /**
     * 根据职位id或编码查询终端列表
     *
     * @return list
     */
    List<MdmTerminalVo> findPositionTerminalList(String posId, String posCode);

    /**
     * 根据职位编码集合查询终端列表
     *
     * @param positionCodeList list
     * @return list
     */
    List<MdmTerminalVo> findPositionTerminalListByPositionCodeList(List<String> positionCodeList);

    /**
     * 根据职位id或编码查询当前及所有下级职位对应的终端集合
     *
     * @return list
     */
    List<MdmTerminalVo> findCurrentAndSybPositionTerminalList(String posId, String posCode);


    /**
     * 根据用户登录编码查询关联终端信息
     * @Param userName
     * @return list
     */
    List<MdmTerminalVo> findTerminalByUserName(String userName);


    /**
     * 批量修改终端关联的企业组织编码
     *
     * @param reqVo reqVo
     */
    void batchUpdateTerminalOrg(MdmOrgTerminalReqVo reqVo);

    /**
     * 获取当前用户的终端及联系人列表
     *
     * @param mdmTerminalContactPageReqVo vo
     * @return page
     */
    PageResult<MdmTerminalContactPageVo> userTerminalContactPage(MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo);

    /**
     * 根据终端编码集合查询主联系人列表
     *
     * @param mdmTerminalContactPageReqVo vo
     * @return page
     */
    PageResult<MdmTerminalContactPageVo> terminalContactPage(MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo);

    /**
     * sfa 根据终端编码集合查询主联系人列表
     * @param terminalCodes
     * @return
     */
    List<MdmTerminalContactPageVo> sfaFindTerminalContactPage(List<String> terminalCodes);

    /**
     * 获取终端组织集合
     *
     * @param vo vo
     * @return list
     */
    List<MdmOrgRespVo> detailBatch(MdmTerminalVo vo);

    /**
     * 根据客户编码或组织编码查询终端信息
     *
     * @param mdmCustomerTerminalVo vo
     * @return list
     */
    List<MdmTerminalVo> customerTerminalList(MdmCustomerTerminalVo mdmCustomerTerminalVo);

    /**
     * 查询职位关联的终端数量
     *
     * @param positionCode 职位编码
     * @return 数量
     */
    Long findPositionRelationTerminalCount(String positionCode);

    /**
     * 查询职位关联的二批商数量
     *
     * @param positionCode 职位编码
     * @return 数量
     */
    Long findPositionRelationTerminalCustomerCount(String positionCode);

    /**
     * 根据营业注册号或终端名称查询详情（当前名称或注册号唯一时）
     *
     * @param licenseRegisterNumber 营业注册号
     * @param terminalName          终端名称
     * @return 详情
     */
    MdmTerminalVo findDetailByRegisterOrName(String licenseRegisterNumber, String terminalName);

    /**
     * 条件查询终端主联系人及距离分页列表
     *
     * @param mdmTerminalDistanceContactPageReqVo vo
     * @return page
     */
    PageResult<MdmTerminalContactPageVo> distanceContactPage(MdmTerminalDistanceContactPageReqVo mdmTerminalDistanceContactPageReqVo);

    /**
     * 终端下拉框
     *
     * @param reqVo vo
     * @return list
     */
    List<MdmTerminalSelectRespVo> findTerminalSelectList(MdmTerminalSelectReqVo reqVo);

    /**
     * 流程审批提交
     *
     * @param reqVo vo
     */
    void submit(MdmTerminalVo reqVo);

    /**
     * 流程审批回调
     *
     * @param reqVo vo
     */
    void callback(ActivitiCallBackVo reqVo);

    /**
     * 状态审批提交
     *
     * @param ids ids
     */
    void statusApprovalSubmit(List<String> ids);

    /**
     * 状态审批驳回
     *
     * @param ids ids
     */
    void statusApprovalReject(List<String> ids);

    /**
     * 状态审批通过
     *
     * @param ids ids
     */
    void statusApprovalAgree(List<String> ids);

    /**
     * 根据终端编码集合，查询供货关系
     *
     * @param mdmTerminalVo 终端
     * @return list
     */
    List<MdmTerminalSupplyVo> findTerminalSupply(MdmTerminalVo mdmTerminalVo);

    /**
     * 条件查询终端及主联系人列表
     *
     * @param mdmTerminalCurrentAndSubVo vo
     * @return list
     */
    PageResult<MdmTerminalContactPageVo> findTerminalAndContactList(MdmTerminalCurrentAndSubVo mdmTerminalCurrentAndSubVo);

    List<MdmTerminalStatisticianTypeVo> statisticalType(MdmTerminalVo mdmTerminalVo);

    Boolean checkTerminalCodeRelByOrgCodeList(List<String> orgCodeList, String terminalCode);

    Boolean checkTerminalCodeRelByCustomerCodeList(List<String> customerCodeList, String terminalCode);

    List<String> checkTerminalCodeRelByOrgOrCusCode(SfaTpmOrgRCusVo orgRCusVo);

    List<MdmTerminalVo> findTerminalByCustomerOrgCodeList(List<String> customerOrgCodeList);

    /**
     * 根据名称和地址查询终端详情
     * @param terminalName  终端名称
     * @param terminalAddress 终端地址
     * @return MdmTerminalVo 终端
     */
    MdmTerminalVo findTerminalByNameOrAddress(String terminalName, String terminalAddress);

  /**
   * 根据终端编码集合查询终端以及附属信息
   * @param terminalCodeList
   * @return
   */
  List<MdmTerminalVo> queryTerminalAndAttachByCode(List<String> terminalCodeList);

    /**
     * 根据组织编码集合查找终端信息
     */
    List<MdmTerminalVo> queryTerminalByOrgCodeList(SfaTPMTerminalReqVo reqVo);
}
