package com.biz.crm.terminal.service.impl;


import com.alibaba.excel.util.DateUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.param.ParameterParam;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.cusorg.entity.MdmCusOrgEntity;
import com.biz.crm.cusorg.service.MdmCusOrgService;
import com.biz.crm.dict.mapper.MdmDictDataMapper;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.mdm.ApprovalType;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.kms.service.MdmStoreService;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.dict.req.MdmDictDataReqVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictDataRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmCustomerTerminalVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalCurrentAndSubVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalDistanceContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalSelectReqVo;
import com.biz.crm.nebular.mdm.terminal.req.TerminalChangeHandlerReqVo;
import com.biz.crm.nebular.mdm.terminal.req.UpdateCoordinateReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalSelectRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmTerminalUserEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemeRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaTPMTerminalReqVo;
import com.biz.crm.nebular.sfa.tpmact.SfaTpmOrgRCusVo;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.region.service.MdmRegionService;
import com.biz.crm.terminal.event.TerminalChangeEvent;
import com.biz.crm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.model.MdmTerminalROrgEntity;
import com.biz.crm.terminal.model.MdmTerminalSupplyEntity;
import com.biz.crm.terminal.service.MdmTerminalContactService;
import com.biz.crm.terminal.service.MdmTerminalElasticsearchService;
import com.biz.crm.terminal.service.MdmTerminalROrgService;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.nebular.mdm.terminal.MdmTencentMapData;
import com.biz.crm.terminal.vo.UpdateTerminalCusOrgCodeVo;
import com.biz.crm.user.service.MdmTerminalUserService;
import com.biz.crm.util.ActivityUtils;
import com.biz.crm.util.ApprovalConfigUtil;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CustomerOrgUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.ReflectUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * @author Liao Hua
 * @date 2020/9/3 3:11 下午
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmTerminalServiceExpandImpl")
public class MdmTerminalServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmTerminalMapper, MdmTerminalEntity> implements MdmTerminalService {

    private static final int PARTION_SIZE = 500;
    private static final int INITIAL_CAPACITY = 16;
    @Resource
    private MdmTerminalMapper mdmTerminalMapper;

    @Autowired
    private MdmTerminalContactService mdmTerminalContactService;
    @Autowired
    private MdmTerminalSupplyService mdmTerminalSupplyService;
    @Autowired
    private MdmOrgService mdmOrgService;
    @Autowired
    private MdmPositionService mdmPositionService;
    @Autowired
    private RocketMQProducer rocketMQProducer;
    @Value("${rocketmq.topic}" + "${rocketmq.environment-variable}")
    private String topic;
    @Autowired
    private MdmTerminalROrgService mdmTerminalROrgService;
    @Autowired
    private TaActBaseFeign taActBaseFeign;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Autowired
    private MdmTerminalElasticsearchService elasticsearchService;
    @Autowired
    private MdmStoreService mdmStoreService;
    @Autowired
    private ElasticsearchRestTemplate elasticsearchRestTemplate;
    @Autowired
    private MdmCusOrgService mdmCusOrgService;
    @Resource
    private MdmDictDataMapper mdmDictDataMapper;
    @Autowired
    private MdmTerminalUserService mdmTerminalUserService;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private MdmRegionService mdmRegionService;

    @Override
    public PageResult<MdmTerminalVo> findList(MdmTerminalVo mdmTerminalReqVo) {
        Page<MdmTerminalVo> page = PageUtil.buildPage(mdmTerminalReqVo.getPageNum(), mdmTerminalReqVo.getPageSize());
        if (!StringUtils.isEmpty(mdmTerminalReqVo.getCode())) {
            List<String> orgCodeList = mdmOrgService.findAllChildrenOrgCodeList(null, mdmTerminalReqVo.getCode());
            mdmTerminalReqVo.setOrgCodeList(orgCodeList);
        }
        List<MdmTerminalVo> list = mdmTerminalMapper.findList(page, mdmTerminalReqVo);
        setUpOrgName(list);
        return PageResult.<MdmTerminalVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    protected void setUpOrgName(List<MdmTerminalVo> list) {
        if (!CollectionUtils.isEmpty(list)) {
            List<String> orgCodeList = list.stream().map(MdmTerminalVo::getOrgCode).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            List<String> ext4List = list.stream().map(MdmTerminalVo::getExt4).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            List<String> ext6List = list.stream().map(MdmTerminalVo::getExt6).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            Set<String> totalOrgCodeList = new HashSet<>(list.size() * 3);
            totalOrgCodeList.addAll(orgCodeList);
            totalOrgCodeList.addAll(ext4List);
            totalOrgCodeList.addAll(ext6List);
            if (!CollectionUtils.isEmpty(totalOrgCodeList)) {
                Map<String, String> orgNameMap = mdmOrgService.findOrgNameMap(new ArrayList<>(totalOrgCodeList));
                if (!ObjectUtils.isEmpty(orgNameMap)) {
                    for (MdmTerminalVo mdmTerminalVo : list) {
                        mdmTerminalVo.setOrgName(orgNameMap.get(mdmTerminalVo.getOrgCode()));
                        mdmTerminalVo.setExt5(orgNameMap.get(mdmTerminalVo.getExt4()));
                        mdmTerminalVo.setExt7(orgNameMap.get(mdmTerminalVo.getExt6()));
                    }
                }
            }

        }
    }

    @Override
    public MdmTerminalVo query(String id, String terminalCode) {
        if (StringUtils.isEmpty(id) && StringUtils.isEmpty(terminalCode)) {
            return null;
        }
        MdmTerminalVo mdmTerminalVo = mdmTerminalMapper.query(id, terminalCode);
        if (mdmTerminalVo == null) {
            return null;
        }
        String code = mdmTerminalVo.getTerminalCode();
        Assert.hasText(code, "终端编码不能为空");

        mdmTerminalVo.setContacts(mdmTerminalContactService.findByTerminalCode(code));
        mdmTerminalVo.setSupplys(mdmTerminalSupplyService.findByTerminalCode(code));
        setUpOrgName(Collections.singletonList(mdmTerminalVo));
        return mdmTerminalVo;
    }

    @Override
    public MdmTerminalVo queryByTerminalCode(String terminalCode) {
        if (StringUtils.isNotEmpty(terminalCode)) {
            MdmTerminalEntity mdmTerminalentity = lambdaQuery()
                    .eq(MdmTerminalEntity::getTerminalCode, terminalCode)
                    .one();
            if (null != mdmTerminalentity) {
                return CrmBeanUtil.copy(mdmTerminalentity, MdmTerminalVo.class);
            }
        }
        return null;
    }

    @Override
    public List<MdmTerminalVo> queryBatchByTerminalCodeList(List<String> terminalCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList)) {
            return lambdaQuery()
                    .in(MdmTerminalEntity::getTerminalCode, terminalCodeList)
                    .list()
                    .stream().map(x -> CrmBeanUtil.copy(x, MdmTerminalVo.class)).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String save(MdmTerminalVo mdmTerminalVo) {
        AssertUtils.isNotEmpty(mdmTerminalVo.getTerminalName(), "终端名称不能为空");
        if (StringUtils.isEmpty(mdmTerminalVo.getTerminalCode())) {
            mdmTerminalVo.setTerminalCode(CodeUtil.generateCode(CodeRuleEnum.MDM_TERMINAL.getCode()));
        } else {
            Integer count = this.lambdaQuery()
                    .eq(MdmTerminalEntity::getTerminalCode, mdmTerminalVo.getTerminalCode())
                    .count();
            Assert.isTrue(null == count || 1 > count, mdmTerminalVo.getTerminalCode() + "终端编码已存在");
        }

        if (StringUtils.isNotEmpty(mdmTerminalVo.getActApproveStatus())) {
            //TODO 其它地方会传其它的值，临时解决一下
            if (ActApproveStatusEnum.CREATE.getCode().equals(mdmTerminalVo.getActApproveStatus())) {
                mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.SUBMIT.getValue());
            }
            if (ActApproveStatusEnum.APPROVING.getCode().equals(mdmTerminalVo.getActApproveStatus())) {
                mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
            }
            if (ActApproveStatusEnum.APPROVED.getCode().equals(mdmTerminalVo.getActApproveStatus())) {
                mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            }
            if (ActApproveStatusEnum.REJECTED.getCode().equals(mdmTerminalVo.getActApproveStatus())) {
                mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.REJECT.getValue());
            }
            if (ActApproveStatusEnum.INTERRUPT.getCode().equals(mdmTerminalVo.getActApproveStatus())) {
                mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.RECOVER.getValue());
            }
            if (ActApproveStatusEnum.CLOSED.getCode().equals(mdmTerminalVo.getActApproveStatus())) {
                mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.CLOSE.getValue());
            }
        }
        if (StringUtils.isEmpty(mdmTerminalVo.getActApproveStatus()) || !MdmBpmStatusEnum.PASS.getValue().equals(mdmTerminalVo.getActApproveStatus())) {
            if (StringUtils.isNotEmpty(mdmTerminalVo.getApprovalBusinessCode())) {
                ApprovalType approvalType = ApprovalConfigUtil.checkAndGet(mdmTerminalVo.getApprovalBusinessCode(), mdmTerminalVo);
                mdmTerminalVo.setApprovalType(approvalType.getValue());
                if (approvalType == ApprovalType.NULL) {
                    mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
                } else {
                    mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.SUBMIT.getValue());
                }
            }
        }
        if (StringUtils.isEmpty(mdmTerminalVo.getApprovalType())) {
            mdmTerminalVo.setApprovalType(ApprovalType.NULL.getValue());
            mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        }
        //CPS改审批类型为状态审批，审批状态为审批中
        if ("cps".equals(mdmTerminalVo.getFromType())){
            mdmTerminalVo.setApprovalType(ApprovalType.STATUS.getValue());
            mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
        }
        //手动设置id
        mdmTerminalVo.setId(UUID.randomUUID().toString());
        MdmTerminalEntity entity = CrmBeanUtil.copy(mdmTerminalVo, MdmTerminalEntity.class);
        this.setRegionName(entity);
        this.save(entity);

        Map<String, String> map = DictUtil.dictMap(DictConstant.TERMINAL_ADD_SECTION);
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get(DictConstant.TERMINAL_ADD_SECTION_ONTACT_INFORMATION))) {
            mdmTerminalContactService.setUpContact(mdmTerminalVo);
        }
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get(DictConstant.TERMINAL_ADD_SECTION_SUPPLY_RELATIONSHIP))) {
            mdmTerminalSupplyService.setUpSupply(mdmTerminalVo);
        }
//        mdmTerminalROrgService.setUpTerminalRelationOrg(mdmTerminalVo);

        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        if (menuCodeObj != null) {
            crmLogSendUtil.sendForAdd(menuCodeObj.toString(), entity.getId(), entity.getTerminalCode(), entity);
        }
        if (MdmBpmStatusEnum.PASS.getValue().equals(entity.getActApproveStatus())) {
            sendInsertMsg(JsonPropertyUtil.toJsonStringNotEmptyVal(entity));
            sendChangeMsg(Collections.singletonList(mdmTerminalVo.getTerminalCode()));
            sendAchievementMsg(mdmTerminalVo.getTerminalCode(), mdmTerminalVo.getFromType());
        }
        // 新增发送到es，注意设置ID。这里的id不是在entity生成的时候产生的，而是在保存完成之后，将ID设置回来的
        elasticsearchService.add(mdmTerminalVo);
        mdmStoreService.add(mdmTerminalVo);
        //这里判断是否生成终端账户
        if (YesNoEnum.yesNoEnum.Y.getValue().equals(ParamUtil.getParameterValue(ParameterParam.TERMINAL_CREATE_CUSTOMER_USER_AUTOMATIC))) {
            //
            MdmTerminalUserEditReqVo reqVo = new MdmTerminalUserEditReqVo();
            reqVo.setFullName(entity.getTerminalName());
            reqVo.setUserName(entity.getTerminalCode());
            reqVo.setTerminalCode(entity.getTerminalCode());
            reqVo.setUserType(UserTypeEnum.TERMINAL.getCode());
            reqVo.setGender("0");
            List<MdmTerminalContactVo> contactVos =mdmTerminalContactService.findByTerminalCode(entity.getTerminalCode());
            if (CollectionUtil.listNotEmptyNotSizeZero(contactVos)) {
                String phone = contactVos.stream().filter(item->{
                  return  Objects.equals(item.getContactMain(),"1");
                }).map(MdmTerminalContactVo::getContactPhone).findFirst().orElse(null);
                reqVo.setUserPhone(phone);
            }
            reqVo.setUserPassword("123456");
            reqVo.setStartTime(DateUtils.format(new Date(),DateUtils.DATE_FORMAT_19));
            reqVo.setEndTime("2099-01-01 00:00:00");
            UserRedis user = UserUtils.getUser();
            if (Objects.nonNull(user)) {
              reqVo.setCreateOrgCode(user.getOrgcode());
              reqVo.setCreateOrgName(user.getOrgname());
              reqVo.setCreatePosCode(user.getPoscode());
              reqVo.setCreatePosName(user.getPosname());
            }
            this.mdmTerminalUserService.save(reqVo);
        }

        terminalChangeSendEvent(TerminalChangeHandlerReqVo.builder()
                .terminalCode(entity.getTerminalCode())
                .currentOrgCode(entity.getOrgCode())
                .supplyVos(mdmTerminalVo.getSupplys())
                .build());
        return mdmTerminalVo.getTerminalCode();
    }

    @Override
    public void saveTxBatch(MdmTencentMapData mdmTencentMapData){
        List<MdmTencentMapData.MdmTencentMapDataReqVo> data = mdmTencentMapData.getData();
        if(CollectionUtil.listEmpty(data)){
            return;
        }
        Set<String> ids = data.stream().map(MdmTencentMapData.MdmTencentMapDataReqVo::getUserId).collect(Collectors.toSet());

        //根据userName查询所有的职位code
        Map<String, MdmPositionRespVo> hashMap = Maps.newHashMap();
        for (String id : ids) {
            MdmPositionRespVo value = hashMap.get(id);
            if(Objects.isNull(value)){
                MdmPositionRespVo mdmPositionRespVo = mdmPositionService.getUserPrimaryPosition(new MdmUserReqVo().setUserName(id));
                //获取主职位
                value = Objects.isNull(mdmPositionRespVo)?new MdmPositionRespVo():mdmPositionRespVo;
                hashMap.put(id,value);
            }
        }
        dataSaveBatch(data,hashMap);
    }


    @Transactional(rollbackFor = Exception.class)
    public void dataSaveBatch(List<MdmTencentMapData.MdmTencentMapDataReqVo> data,Map<String, MdmPositionRespVo> hashMap){
        //终端
        List<MdmTerminalEntity> mdmTerminalEntities = Lists.newArrayList();
        //供货关系
        List<MdmTerminalSupplyEntity> mdmTerminalSupplyEntities = Lists.newArrayList();
        List<String> terminalCodes = Lists.newArrayList();
        List<String> ids = Lists.newArrayList();
        for (MdmTencentMapData.MdmTencentMapDataReqVo datum : data) {
            //1检查是否已经存在关系
            //等同于终端code
            terminalCodes.add(datum.getPoiId());
            MdmTerminalEntity entity = mdmTerminalMapper.selectOne(new QueryWrapper<>(new MdmTerminalEntity().setTerminalCode(datum.getPoiId())));
            String uuid = UUID.randomUUID().toString();
            if(!Objects.isNull(entity)){
                uuid = entity.getId();
                ids.add(uuid);
            }
            //2添加数据
            tencentFull(uuid,datum,mdmTerminalEntities,mdmTerminalSupplyEntities,hashMap);
        }
        //清空所有已存在关系并且再次新增的关联关系
        mdmTerminalSupplyService.deleteByCodes(terminalCodes);
        //terminal add
        this.saveOrUpdateBatch(mdmTerminalEntities);
        //terminal_supply
        mdmTerminalSupplyService.saveBatch(mdmTerminalSupplyEntities);
        Map<String, MdmTerminalSupplyEntity> collect = mdmTerminalSupplyEntities.stream().collect(Collectors.toMap(MdmTerminalSupplyEntity::getTerminalCode, MdmTerminalSupplyEntity -> MdmTerminalSupplyEntity,(x1, x2) -> x1));
        //删除es 更新操作
        if(!CollectionUtils.isEmpty(ids)){
            try {
                elasticsearchService.delete(ids);
            }catch (Exception e){
                log.error("腾讯地图数据同步删除es异常-原因:{}",e);
            }
        }
        //新增es
        for (MdmTerminalEntity entity : mdmTerminalEntities) {
            MdmTerminalVo vo = new MdmTerminalVo();
            try {
                BeanUtils.copyProperties(entity, vo);
                vo.setAmapId(entity.getTerminalCode());
                List<MdmTerminalSupplyVo> supplyVos = Lists.newArrayList();
                MdmTerminalSupplyVo mdm = new MdmTerminalSupplyVo();
                BeanUtils.copyProperties(collect.get(entity.getTerminalCode()), mdm);
                supplyVos.add(mdm);
                vo.setSupplys(supplyVos);
                elasticsearchService.add(vo);
            } catch (Exception e) {
                throw new BusinessException("Bean转换异常");
            }
        }
    }

    private void tencentFull(String uuid,MdmTencentMapData.MdmTencentMapDataReqVo datum,List<MdmTerminalEntity> mdmTerminalEntities,List<MdmTerminalSupplyEntity> mdmTerminalSupplyEntities,Map<String, MdmPositionRespVo> hashMap){
        //终端数据
        MdmTerminalEntity mdmTerminalEntity = new MdmTerminalEntity();
        mdmTerminalEntity.setId(uuid);
        mdmTerminalEntity.setTerminalCode(datum.getPoiId());
        mdmTerminalEntity.setTerminalName(datum.getPoiTitle());
        mdmTerminalEntity.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        mdmTerminalEntity.setTerminalType("1");
        mdmTerminalEntity.setTerminalAddress(datum.getPoiAddress());
        //TODO 组织暂时没有
        mdmTerminalEntity.setOrgCode("ZH00001528");
        mdmTerminalEntity.setLongitude(datum.getLng());
        mdmTerminalEntity.setLatitude(datum.getLat());
        mdmTerminalEntity.setChannel(datum.getChannel());
        //省份
        mdmTerminalEntity.setProvinceName(mdmRegionService.queryByName(datum.getProvince()));
        mdmTerminalEntity.setProcessCode(datum.getProvince());
        //城市
        mdmTerminalEntity.setCityName(mdmRegionService.queryByName(datum.getCity()));
        mdmTerminalEntity.setCityCode(datum.getCity());
        //区县
        mdmTerminalEntity.setDistrictName(mdmRegionService.queryByName(datum.getDistrict()));
        mdmTerminalEntity.setDistrictCode(datum.getDistrict());
        //todo 业态
        mdmTerminalEntity.setExt1(datum.getBusiType());
        mdmTerminalEntities.add(mdmTerminalEntity);

        //关联关系
        MdmTerminalSupplyEntity mdmTerminalSupplyEntity = new MdmTerminalSupplyEntity();
        mdmTerminalSupplyEntity.setId(UUID.randomUUID().toString());
        MdmPositionRespVo vo = hashMap.get(datum.getUserId());
        mdmTerminalSupplyEntity.setTerminalCode(datum.getPoiId());
        mdmTerminalSupplyEntity.setUserName(datum.getUserId());
        mdmTerminalSupplyEntity.setOrgCode(vo.getOrgCode());
        mdmTerminalSupplyEntity.setPositionCode(vo.getPositionCode());
        //品牌编码
        mdmTerminalSupplyEntity.setExt1(datum.getBrandId());
        //品牌名称
        mdmTerminalSupplyEntity.setExt2(datum.getBrandName());
        mdmTerminalSupplyEntities.add(mdmTerminalSupplyEntity);
    }



    /**
     * 新增成功 计算绩效和积分
     *
     * @param terminalCode
     * @param fromType
     */
    private void sendAchievementMsg(String terminalCode, String fromType){
            ArrayList<String> list = Lists.newArrayList();
            list.add(terminalCode);
            list.add(fromType);
            RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
            rocketMQMessageBody.setTag(RocketMQConstant.CRM_MQ_TAG.INSERT_CLIENT_TAG);
            rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonStringNotEmptyVal(list));
            rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String saveAndSubmit(MdmTerminalVo mdmTerminalVo) {
        String approvalBusinessCode = mdmTerminalVo.getApprovalBusinessCode();
        Assert.hasText(approvalBusinessCode, "缺失审批配置业务编码，不能自动发起");
        MdmApprovalConfigVo config = ApprovalConfigUtil.getConfig(approvalBusinessCode);
        String terminalCode = this.save(mdmTerminalVo);
        MdmTerminalEntity terminal = this.lambdaQuery()
                .eq(MdmTerminalEntity::getTerminalCode, terminalCode)
                .one();
        if (MdmBpmStatusEnum.SUBMIT.getValue().equals(terminal.getActApproveStatus())) {
            if (ApprovalType.STATUS.getValue().equals(terminal.getApprovalType())) {
                this.lambdaUpdate()
                        .eq(MdmTerminalEntity::getTerminalCode, terminalCode)
                        .set(MdmTerminalEntity::getActApproveStatus, MdmBpmStatusEnum.APPROVAL.getValue())
                        .update();
                elasticsearchService.updateById(terminal.getId(),Collections.singletonMap("actApproveStatus",MdmBpmStatusEnum.APPROVAL.getValue()));
            }
            if (ApprovalType.BPM.getValue().equals(terminal.getApprovalType())) {
                String workFlowKey = mdmTerminalVo.getWorkFlowKey();
                if (StringUtils.isEmpty(workFlowKey)) {
                    Assert.notNull(config, "未找到审批配置");
                    Assert.hasText(config.getDefaultWorkFlowKey(), "审批配置缺失流程key");
                    workFlowKey = config.getDefaultWorkFlowKey();
                }
                UserRedis user = UserUtils.getUser();
                StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
                startProcessReqVo.setCallBackFeign("MdmTerminalCallBackFeign");
                startProcessReqVo.setProcessKey(workFlowKey);
                startProcessReqVo.setUserCode(user.getUsername());
                startProcessReqVo.setPosCode(user.getPoscode());
                startProcessReqVo.setTitle(StringUtils.isNotEmpty(mdmTerminalVo.getTitle()) ? mdmTerminalVo.getTitle() : "客户新增默认提交流程");
                startProcessReqVo.setFormNo(terminal.getId());
                startProcessReqVo.setRemark(StringUtils.isNotEmpty(mdmTerminalVo.getApproveRemarks()) ? mdmTerminalVo.getApproveRemarks() : "");
                startProcessReqVo.setFormType(StringUtils.isNotEmpty(mdmTerminalVo.getFromType()) ? mdmTerminalVo.getFromType() : "MDM");
                startProcessReqVo.setCostType("terminal");
                startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
                startProcessReqVo.setBusinessCode(terminal.getTerminalCode());
                startProcessReqVo.setFileList(CollectionUtil.listNotEmptyNotSizeZero(mdmTerminalVo.getActivityFileList()) ? mdmTerminalVo.getActivityFileList() : null);
                String processNo = ActivityUtils.startProcess(startProcessReqVo);
                this.lambdaUpdate()
                        .eq(MdmTerminalEntity::getTerminalCode, terminalCode)
                        .set(MdmTerminalEntity::getActApproveStatus, MdmBpmStatusEnum.APPROVAL.getValue())
                        .set(MdmTerminalEntity::getProcessCode, processNo)
                        .update();
                elasticsearchService.updateById(terminal.getId(),Collections.singletonMap("actApproveStatus",MdmBpmStatusEnum.APPROVAL.getValue()));
            }
        }
        return terminalCode;
    }

    @Override
    public String validateSaveParamFromSfa(MdmTerminalVo reqVo) {
        Assert.notNull(reqVo, "空参数");
        List<DictDataVo> list = DictUtil.list(DictConstant.MDM_UNIQUE_CHECK_TERMINAL_ADD_FROM_SFA);
        for (DictDataVo dictDataVo :
                list) {
            String dictCode = dictDataVo.getDictCode();
            String dictValue = dictDataVo.getDictValue();
            Object filedValueByName = ReflectUtil.getFiledValueByName(reqVo, dictCode);
            if (filedValueByName != null && StringUtils.isNotEmpty(filedValueByName.toString())) {
                QueryWrapper<MdmTerminalEntity> wrapper = new QueryWrapper<>();
                wrapper.eq(dictValue, filedValueByName.toString());
                wrapper.select("id", "act_approve_status");
                List<MdmTerminalEntity> terminalEntityList = mdmTerminalMapper.selectList(wrapper);
                if (terminalEntityList.size() > 1) {
                    throw new BusinessException("存在多个重复终端，请联系相关人员停用重复终端");
                } else if (terminalEntityList.size() == 1) {
                    MdmTerminalEntity terminalEntity = terminalEntityList.get(0);
                    String actApproveStatus = terminalEntity.getActApproveStatus();
                    if (ActApproveStatusEnum.APPROVING.getCode().equals(actApproveStatus)) {
                        throw new BusinessException("存在一个审批中的重复终端，请联系相关人员审批后再进行新增");
                    }
                    return terminalEntity.getId();
                }
            }
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(MdmTerminalVo mdmTerminalVo) {
        String terminalCode = mdmTerminalVo.getTerminalCode();
        Assert.hasText(terminalCode, "终端编码不能为空");
        String id = mdmTerminalVo.getId();
        Assert.hasText(id, "数据主键不能为空");
        MdmTerminalVo oldObject = this.queryById(mdmTerminalVo);
        MdmTerminalEntity entity = this.getById(mdmTerminalVo.getId());
        Assert.notNull(entity, "终端不存在");
        long count = this.lambdaQuery()
                .eq(MdmTerminalEntity::getTerminalCode, terminalCode)
                .select(MdmTerminalEntity::getId)
                .list().stream().filter(x -> !id.equals(x.getId()))
                .count();
        Assert.isTrue(count < 1L, "终端编码已存在");
        MdmTerminalEntity copy = CrmBeanUtil.copy(mdmTerminalVo, MdmTerminalEntity.class);
        this.setRegionName(copy);
        this.updateById(copy);
        Map<String, String> map = DictUtil.dictMap(DictConstant.TERMINAL_ADD_SECTION);
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get(DictConstant.TERMINAL_ADD_SECTION_ONTACT_INFORMATION))) {
            mdmTerminalContactService.setUpContact(mdmTerminalVo);
        }
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get(DictConstant.TERMINAL_ADD_SECTION_SUPPLY_RELATIONSHIP))) {
            mdmTerminalSupplyService.setUpSupply(mdmTerminalVo);
        }
//        mdmTerminalROrgService.setUpTerminalRelationOrg(mdmTerminalVo);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        MdmTerminalVo newObject = this.queryById(mdmTerminalVo);
        if (menuCodeObj != null) {
            crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), mdmTerminalVo.getId(), newObject.getTerminalCode(), oldObject, newObject);
        }

        if (MdmBpmStatusEnum.PASS.getValue().equals(entity.getActApproveStatus())) {
        /// 编辑发送到es，需要带上ID和职位编码，更新操作应该会带上的，不然mysql也没法更新
        elasticsearchService.add(mdmTerminalVo);
            sendChangeMsg(Collections.singletonList(mdmTerminalVo.getTerminalCode()));
        }

        if (null != mdmTerminalVo) {
            //发送mq
            RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
            rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(mdmTerminalVo));
            rocketMQMessageBody.setTag(RocketMQConstant.CRM_MQ_TAG.TERMINAL_REFRESH);
            rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
        mdmStoreService.update(mdmTerminalVo);

        terminalChangeSendEvent(TerminalChangeHandlerReqVo.builder()
                .terminalCode(entity.getTerminalCode())
                .oldOrgCode(oldObject.getOrgCode())
                .currentOrgCode(entity.getOrgCode())
                .supplyVos(mdmTerminalVo.getSupplys())
                .build());
    }


    @Override
    public void updateCoordinate(List<UpdateCoordinateReqVo> updateCoordinateReqVos) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(updateCoordinateReqVos)) {
            return;
        }
        for (UpdateCoordinateReqVo updateCoordinateReqVo : updateCoordinateReqVos) {
            String terminalCode = updateCoordinateReqVo.getTerminalCode();
            if (!com.biz.crm.util.StringUtils.isEmpty(terminalCode)) {
                this.lambdaUpdate()
                        .eq(MdmTerminalEntity::getTerminalCode, terminalCode)
                        .set(MdmTerminalEntity::getLongitude, updateCoordinateReqVo.getLongitude())
                        .set(MdmTerminalEntity::getLatitude, updateCoordinateReqVo.getLatitude())
                        .update();
            }
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateAndSubmit(MdmTerminalVo mdmTerminalVo) {
        this.update(mdmTerminalVo);
        String terminalCode = mdmTerminalVo.getTerminalCode();
        MdmTerminalEntity terminal = this.lambdaQuery()
                .eq(MdmTerminalEntity::getTerminalCode, terminalCode)
                .one();
        if (MdmBpmStatusEnum.SUBMIT.getValue().equals(terminal.getActApproveStatus()) || MdmBpmStatusEnum.RECOVER.getValue().equals(terminal.getActApproveStatus()) || MdmBpmStatusEnum.REJECT.getValue().equals(terminal.getActApproveStatus())) {
            if (ApprovalType.STATUS.getValue().equals(terminal.getApprovalType())) {
                this.lambdaUpdate()
                        .eq(MdmTerminalEntity::getTerminalCode, terminalCode)
                        .set(MdmTerminalEntity::getActApproveStatus, MdmBpmStatusEnum.APPROVAL.getValue())
                        .update();
                elasticsearchService.updateById(terminal.getId(), Collections.singletonMap("actApproveStatus", MdmBpmStatusEnum.APPROVAL.getValue()));
            } else if (ApprovalType.BPM.getValue().equals(terminal.getApprovalType())) {
                Assert.hasText(mdmTerminalVo.getApprovalBusinessCode(), "缺失审批配置编码");

                String workFlowKey = mdmTerminalVo.getWorkFlowKey();
                if (StringUtils.isEmpty(workFlowKey)) {
                    MdmApprovalConfigVo config = ApprovalConfigUtil.getConfig(mdmTerminalVo.getApprovalBusinessCode());
                    Assert.notNull(config, "未找到审批配置编码" + mdmTerminalVo.getApprovalBusinessCode());
                    Assert.hasText(config.getDefaultWorkFlowKey(), "审批配置未配置默认流程key");
                    workFlowKey = config.getDefaultWorkFlowKey();
                }
                UserRedis user = UserUtils.getUser();
                StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
                startProcessReqVo.setCallBackFeign("MdmTerminalCallBackFeign");
                startProcessReqVo.setProcessKey(workFlowKey);
                startProcessReqVo.setUserCode(user.getUsername());
                startProcessReqVo.setPosCode(user.getPoscode());
                startProcessReqVo.setTitle(StringUtils.isNotEmpty(mdmTerminalVo.getTitle()) ? mdmTerminalVo.getTitle() : "终端编辑默认提交流程");
                startProcessReqVo.setFormNo(terminal.getId());
                startProcessReqVo.setRemark(StringUtils.isNotEmpty(mdmTerminalVo.getApproveRemarks()) ? mdmTerminalVo.getApproveRemarks() : "");
                startProcessReqVo.setFormType(StringUtils.isNotEmpty(mdmTerminalVo.getFromType()) ? mdmTerminalVo.getFromType() : "MDM");
                startProcessReqVo.setCostType("terminal");
                startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
                startProcessReqVo.setBusinessCode(terminal.getTerminalCode());
                startProcessReqVo.setFileList(CollectionUtil.listNotEmptyNotSizeZero(mdmTerminalVo.getActivityFileList()) ? mdmTerminalVo.getActivityFileList() : null);
                String no = ActivityUtils.startProcess(startProcessReqVo);

                this.lambdaUpdate()
                        .eq(MdmTerminalEntity::getTerminalCode, terminalCode)
                        .set(MdmTerminalEntity::getActApproveStatus, MdmBpmStatusEnum.APPROVAL.getValue())
                        .set(MdmTerminalEntity::getProcessCode, no)
                        .update();
                elasticsearchService.updateById(terminal.getId(), Collections.singletonMap("actApproveStatus", MdmBpmStatusEnum.APPROVAL.getValue()));

            } else {
                this.lambdaUpdate()
                        .eq(MdmTerminalEntity::getTerminalCode, terminalCode)
                        .set(MdmTerminalEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                        .update();
                elasticsearchService.updateById(terminal.getId(), Collections.singletonMap("actApproveStatus", MdmBpmStatusEnum.PASS.getValue()));
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("请选择一条数据");
        }
        List<MdmTerminalEntity> list = this.lambdaQuery()
                .in(MdmTerminalEntity::getId, ids)
                .list();
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        List<String> terminalCodes = list.stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList());
        //删除联系人
        mdmTerminalContactService.deleteByCodes(terminalCodes);
        //删除供货关系
        mdmTerminalSupplyService.deleteByCodes(terminalCodes);
        mdmTerminalROrgService.lambdaUpdate()
                .in(MdmTerminalROrgEntity::getTerminalCode, terminalCodes)
                .remove();
        mdmStoreService.remove(terminalCodes);
        //删除终端
        this.removeByIds(ids);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        if (menuCodeObj != null) {
            list.forEach(item -> {
                crmLogSendUtil.sendForDel(menuCodeObj.toString(),
                        item.getId(), item.getTerminalCode(), item);
                // 删除发送到es
                //sendElasticsearch(item);

            });
        }
        try {
            elasticsearchService.delete(ids);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        sendChangeMsg(list.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("请选择一条数据");
        }
        List<MdmTerminalEntity> list = this.lambdaQuery()
                .in(MdmTerminalEntity::getId, ids)
                .select(MdmTerminalEntity::getId, MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getEnableStatus)
                .list()
                .stream().filter(x -> !CrmEnableStatusEnum.ENABLE.getCode().equals(x.getEnableStatus())).collect(Collectors.toList());
        this.lambdaUpdate()
                .in(MdmTerminalEntity::getId, ids)
                .set(MdmTerminalEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                .update();
        sendChangeMsg(list.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList()));
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        if (menuCodeObj != null) {
            list.forEach(item -> {
                MdmTerminalVo oldObject = CrmBeanUtil.copy(item, MdmTerminalVo.class);
                oldObject.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                MdmTerminalVo newObject = CrmBeanUtil.copy(item, MdmTerminalVo.class);
                newObject.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), item.getId(), item.getTerminalCode(), oldObject, newObject);
            });
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("请选择一条数据");
        }
        List<MdmTerminalEntity> list = this.lambdaQuery()
                .in(MdmTerminalEntity::getId, ids)
                .select(MdmTerminalEntity::getId, MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getEnableStatus)
                .list()
                .stream().filter(x -> !CrmEnableStatusEnum.DISABLE.getCode().equals(x.getEnableStatus())).collect(Collectors.toList());
        this.lambdaUpdate()
                .in(MdmTerminalEntity::getId, ids)
                .set(MdmTerminalEntity::getEnableStatus, CrmEnableStatusEnum.DISABLE.getCode())
                .update();
        sendChangeMsg(list.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList()));
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        if (menuCodeObj != null) {
            list.forEach(item -> {
                MdmTerminalVo oldObject = CrmBeanUtil.copy(item, MdmTerminalVo.class);
                oldObject.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                MdmTerminalVo newObject = CrmBeanUtil.copy(item, MdmTerminalVo.class);
                newObject.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), item.getId(), item.getTerminalCode(), oldObject, newObject);
            });
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateCusOrgCode(UpdateTerminalCusOrgCodeVo vo) {
        if (CollectionUtil.listEmpty(vo.getTerminalCodeList()) || StringUtils.isEmpty(vo.getCustomerOrgCode())) {
            throw new BusinessException("客户组织编码或终端编码集合不能为空");
        }
        List<MdmTerminalEntity> list = this.lambdaQuery()
                .in(MdmTerminalEntity::getTerminalCode, vo.getTerminalCodeList())
                .select(MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getActApproveStatus)
                .list();
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.lambdaUpdate()
                .in(MdmTerminalEntity::getTerminalCode, vo.getTerminalCodeList())
                .set(MdmTerminalEntity::getCustomerOrgCode, vo.getCustomerOrgCode())
                .update();
        sendChangeMsg(list.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList()));
    }


    @Override
    public List<String> findByOrgCodeList(List<String> list) {
        if (CollectionUtil.listEmpty(list)) {
            return new ArrayList<>();
        }
        List<String> terminalCodeList = mdmTerminalROrgService.findTerminalCodeByOrg(list);
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return new ArrayList<>();
        }
        return this.lambdaQuery()
                .eq(MdmTerminalEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                .in(MdmTerminalEntity::getTerminalCode, terminalCodeList)
                .select(MdmTerminalEntity::getTerminalCode)
                .list()
                .stream()
                .map(MdmTerminalEntity::getTerminalCode)
                .collect(Collectors.toList());
    }

    @Override
    public Map<String, String> getTerminalCodeNameMap(List<String> terminalCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList)) {
            Map<String, String> map = new HashMap<>(INITIAL_CAPACITY);
            List<List<String>> partition = Lists.partition(terminalCodeList, PARTION_SIZE);
            for (List<String> group :
                    partition) {
                map.putAll(this.lambdaQuery()
                        .in(MdmTerminalEntity::getTerminalCode, group)
                        .select(MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getTerminalName)
                        .list()
                        .stream()
                        .collect(Collectors.toMap(MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getTerminalName)));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, String> findOrgCodeByTerminalCodeList(List<String> terminalCodeList) {
        if (CollectionUtil.listEmpty(terminalCodeList)) {
            return Collections.emptyMap();
        }
        return mdmTerminalROrgService.findOrgCodeByTerminalCodeList(terminalCodeList);
//        List<MdmTerminalEntity> list = this.lambdaQuery()
//                .in(MdmTerminalEntity::getTerminalCode, terminalCodeList)
//                .select(MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getOrgCode)
//                .list();
//        if (CollectionUtil.listEmpty(list)) {
//            return Collections.emptyMap();
//        }
//        return list.stream().collect(Collectors.toMap(MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getOrgCode));
    }

    @Override
    public Map<String, List<String>> findOrgCodeListByTerminalCodeList(List<String> terminalCodeList) {
        return mdmTerminalROrgService.findOrgCodeList(terminalCodeList);
//        Map<String, List<String>> map = new HashMap<>();
//        if (CollectionUtils.isEmpty(terminalCodeList)) {
//            return Collections.emptyMap();
//        }
//        List<MdmTerminalEntity> list = this.lambdaQuery()
//                .in(MdmTerminalEntity::getTerminalCode, terminalCodeList)
//                .select(MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getOrgCode)
//                .list();
//        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
//
//            map = list.stream().collect(Collectors.toMap(MdmTerminalEntity::getTerminalCode, v -> {
//                List<String> orgCodeList = new ArrayList<>();
//                if (StringUtils.isEmpty(v.getOrgCode())) {
//                    orgCodeList.add(v.getOrgCode());
//                }
//                return orgCodeList;
//            }));
//            List<MdmTerminalSupplyEntity> supplyList = mdmTerminalSupplyService.lambdaQuery()
//                    .in(MdmTerminalSupplyEntity::getTerminalCode, terminalCodeList)
//                    .select(MdmTerminalSupplyEntity::getTerminalCode, MdmTerminalSupplyEntity::getOrgCode)
//                    .list();
//            if (CollectionUtil.listNotEmptyNotSizeZero(supplyList)) {
//                Map<String, Set<String>> collect = supplyList.stream().filter(item -> StringUtils.isNotEmpty(item.getOrgCode())).collect(Collectors.groupingBy(MdmTerminalSupplyEntity::getTerminalCode, Collectors.mapping(MdmTerminalSupplyEntity::getOrgCode, Collectors.toSet())));
//                if (!collect.isEmpty()) {
//                    for (Map.Entry<String, List<String>> entry :
//                            map.entrySet()) {
//                        if (collect.containsKey(entry.getKey())) {
//                            Set<String> strings = collect.get(entry.getKey());
//                            strings.addAll(entry.getValue());
//                            entry.setValue(new ArrayList<>(strings));
//                        }
//                    }
//                }
//            }
//        }
//        return map;
    }


    @Override
    public List<MdmTerminalVo> findCurrentAndSubTerminalList(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return new ArrayList<>();
        }
        List<String> allOrgCodeList = OrgUtil.getChildrenOrgCodeListIncludeSelfEnable(orgCodes);
        if (CollectionUtils.isEmpty(allOrgCodeList)) {
            return new ArrayList<>();
        }
        MdmTerminalCurrentAndSubVo mdmTerminalCurrentAndSubVo = new MdmTerminalCurrentAndSubVo();
        mdmTerminalCurrentAndSubVo.setPageNum(0);
        mdmTerminalCurrentAndSubVo.setPageSize(Integer.MAX_VALUE);
        mdmTerminalCurrentAndSubVo.setOrgCodeList(allOrgCodeList);
        return CrmBeanUtil.copyList(findTerminalAndContactList(mdmTerminalCurrentAndSubVo).getData(), MdmTerminalVo.class);
    }

    @Override
    public List<MdmTerminalVo> listCondition(MdmTerminalVo mdmTerminalReqVo) {
        Page<MdmTerminalVo> page = PageUtil.buildPage(mdmTerminalReqVo.getPageNum(), mdmTerminalReqVo.getPageSize());
        page.setSearchCount(false);
        return mdmTerminalMapper.listCondition(mdmTerminalReqVo, page);
    }

    protected void sendInsertMsg(String msg) {
        log.info("终端新增消息通知:{}", msg);
        if (StringUtils.isBlank(msg)) {
            return;
        }
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTopic(topic);
        rocketMQMessageBody.setTag(RocketMQConstant.CRM_MQ_TAG.TERMINAL_NEW_OR_PASS);
        rocketMQMessageBody.setMsgBody(msg);
        rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    /**
     * 变动通知
     *
     * @param terminalCodeList 终端编码集合
     */
    private void sendChangeMsg(List<String> terminalCodeList) {
        log.info("终端变动消息通知:{}", terminalCodeList);
        if (CollectionUtil.listEmpty(terminalCodeList)) {
            return;
        }
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTopic(topic);
        rocketMQMessageBody.setTag(RocketMQConstant.CRM_MQ_TAG.TERMINAL_AVAILBLELIST_REFRSH);
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(terminalCodeList));
        rocketMQProducer.convertAndSend(rocketMQMessageBody);
//        advise.adviseTarget(terminalChangeAdviseTargetStrategy, terminalCodeList);
    }

    @Override
    public List<MdmTerminalVo> findPositionTerminalList(String posId, String posCode) {
        if (StringUtils.isEmpty(posCode) && StringUtils.isEmpty(posId)) {
            return new ArrayList<>();
        }
        return mdmTerminalMapper.findPositionTerminalList(posId, posCode).stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).collect(Collectors.toList());
    }

    @Override
    public List<MdmTerminalVo> findPositionTerminalListByPositionCodeList(List<String> positionCodeList) {
        if (CollectionUtil.listEmpty(positionCodeList)) {
            return new ArrayList<>();
        }
        return mdmTerminalMapper.findPositionsTerminalList(positionCodeList).stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).collect(Collectors.toList());
    }

    @Override
    public List<MdmTerminalVo> findCurrentAndSybPositionTerminalList(String posId, String posCode) {
        List<String> positionCodeList = mdmPositionService.findAllChildrenPositionCodeList(posId, posCode);
        if (CollectionUtil.listEmpty(positionCodeList)) {
            return new ArrayList<>();
        }
        return mdmTerminalMapper.findPositionsTerminalList(positionCodeList).stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).collect(Collectors.toList());
    }

    @Override
    public List<MdmTerminalVo> findTerminalByUserName(String userName) {
        Assert.hasText(userName,"缺失用户登录编码");
        return mdmTerminalMapper.findTerminalByUserName(userName);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchUpdateTerminalOrg(MdmOrgTerminalReqVo reqVo) {
        Assert.notEmpty(reqVo.getTerminalCodeList(), "缺失终端编码");
        Assert.hasText(reqVo.getOrgCode(), "缺失组织编码");
        if (StringUtils.isNotEmpty(reqVo.getOriginOrgCode())) {
            mdmTerminalROrgService.replaceOrg(reqVo.getTerminalCodeList(), reqVo.getOriginOrgCode(), reqVo.getOrgCode());
        } else {
            mdmTerminalROrgService.setUp(reqVo.getTerminalCodeList(), reqVo.getOrgCode());
        }
        List<String> sendTerminalCodeList = this.lambdaQuery()
                .eq(MdmTerminalEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                .in(MdmTerminalEntity::getTerminalCode, reqVo.getTerminalCodeList())
                .select(MdmTerminalEntity::getTerminalCode)
                .list()
                .stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList());
        if (CollectionUtil.listNotEmptyNotSizeZero(sendTerminalCodeList)) {
            sendChangeMsg(sendTerminalCodeList);
        }
    }

    @Override
    public PageResult<MdmTerminalContactPageVo> userTerminalContactPage(MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo) {
        String positionCode = mdmTerminalContactPageReqVo.getPositionCode();
        List<String> positionCodeList = mdmTerminalContactPageReqVo.getPositionCodeList() != null ? mdmTerminalContactPageReqVo.getPositionCodeList() : new ArrayList<>();
        List<String> terminalCodeList = new ArrayList<>();
        if (!StringUtils.isEmpty(mdmTerminalContactPageReqVo.getPositionCode()) || CollectionUtil.listNotEmptyNotSizeZero(mdmTerminalContactPageReqVo.getPositionCodeList())) {
            if (StringUtils.isNotEmpty(mdmTerminalContactPageReqVo.getPositionCode())) {
                if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
                    positionCodeList.retainAll(Collections.singletonList(positionCode));
                } else {
                    positionCodeList.add(positionCode);
                }
            }
            if (!CollectionUtils.isEmpty(positionCodeList)) {
                List<MdmTerminalVo> positionTerminalList = findPositionTerminalListByPositionCodeList(positionCodeList);
                log.info("[终端管理][终端及主联系人分页]职位关联终端:{}", positionTerminalList);
                if (CollectionUtils.isEmpty(positionTerminalList)) {
                    return new PageResult<>();
                }
                terminalCodeList = positionTerminalList.stream()
                        .map(MdmTerminalVo::getTerminalCode)
                        .collect(Collectors.toList());
            }
        } else {
//            throw new BusinessException("缺失职位编码");
        }

        mdmTerminalContactPageReqVo.setTerminalCodeList(terminalCodeList);
        Page<MdmTerminalContactPageVo> page = PageUtil.buildPage(mdmTerminalContactPageReqVo.getPageNum(), mdmTerminalContactPageReqVo.getPageSize());
        List<MdmTerminalContactPageVo> list;
        mdmTerminalContactPageReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        if (!StringUtils.isEmpty(mdmTerminalContactPageReqVo.getLatitude()) && !StringUtils.isEmpty(mdmTerminalContactPageReqVo.getLongitude())) {
            list = mdmTerminalMapper.distancePage(page, mdmTerminalContactPageReqVo);
        } else {
            list = mdmTerminalMapper.userTerminalContactPage(page, mdmTerminalContactPageReqVo);
        }
        return PageResult.<MdmTerminalContactPageVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<MdmTerminalContactPageVo> terminalContactPage(MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo) {
        Page<MdmTerminalContactPageVo> page = PageUtil.buildPage(mdmTerminalContactPageReqVo.getPageNum(), mdmTerminalContactPageReqVo.getPageSize());
        mdmTerminalContactPageReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<String> positionCodeList = mdmTerminalContactPageReqVo.getPositionCodeList();
        if (!CollectionUtils.isEmpty(positionCodeList)) {
            //如果职位有搜索条件，就不走数据权限
            ThreadLocalUtil.delObj();
        }

        List<MdmTerminalContactPageVo> list = mdmTerminalMapper.userTerminalContactPage(page, mdmTerminalContactPageReqVo);
        return PageResult.<MdmTerminalContactPageVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public List<MdmTerminalContactPageVo> sfaFindTerminalContactPage(List<String> terminalCodes) {
        List<MdmTerminalContactPageVo> data = new ArrayList<>();
        List<List<String>> list = Lists.partition(terminalCodes, 500);
        list.forEach(l -> {
            final MdmTerminalContactPageReqVo reqVo = new MdmTerminalContactPageReqVo() {{
                this.setTerminalCodeList(l);
                this.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            }};
            List<MdmTerminalContactPageVo> terminalList = mdmTerminalMapper.userTerminalContactPage(null, reqVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(terminalList)){
                data.addAll(terminalList);
            }
        });
        return data;
    }

    @Override
    public List<MdmOrgRespVo> detailBatch(MdmTerminalVo vo) {
        List<String> orgCodeList = this.lambdaQuery()
                .eq(MdmTerminalEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                .in(!CollectionUtils.isEmpty(vo.getTerminalCodeList()), MdmTerminalEntity::getTerminalCode, vo.getTerminalCode())
                .like(!StringUtils.isEmpty(vo.getTerminalName()), MdmTerminalEntity::getTerminalName, vo.getTerminalName())
                .select(MdmTerminalEntity::getOrgCode)
                .list()
                .stream()
                .filter(x -> x != null && !StringUtils.isEmpty(x.getOrgCode()))
                .map(MdmTerminalEntity::getOrgCode)
                .distinct()
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orgCodeList)) {
            return new ArrayList<>();
        }
        return mdmOrgService.detailBatch(null, orgCodeList);
    }

    @Override
    public List<MdmTerminalVo> customerTerminalList(MdmCustomerTerminalVo mdmCustomerTerminalVo) {
        Page<MdmTerminalVo> page = PageUtil.buildPage(mdmCustomerTerminalVo.getPageNum(), mdmCustomerTerminalVo.getPageSize());
        List<String> customerCodeList = mdmCustomerTerminalVo.getCustomerCodeList();
        if (!CollectionUtils.isEmpty(customerCodeList)) {
            List<String> terminalByCustomer = mdmTerminalSupplyService.findTerminalByCustomer(customerCodeList);
            if (CollectionUtils.isEmpty(terminalByCustomer)) {
                return new ArrayList<>();
            }
            mdmCustomerTerminalVo.setTerminalCodeList(terminalByCustomer);
        }
        page.setSearchCount(false);
        List<MdmTerminalVo> collect = mdmTerminalMapper.customerTerminalList(page, mdmCustomerTerminalVo).stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).collect(Collectors.toList());
        if (!collect.isEmpty() && YesNoEnum.yesNoEnum.Y.getValue().equals(mdmCustomerTerminalVo.getIsQueryTerminalOrgList())) {
            Map<String, List<MdmOrgRespVo>> orgGroupByTerminalCodeList = mdmTerminalROrgService.findOrgGroupByTerminalCodeList(collect.stream().map(MdmTerminalVo::getTerminalCode).collect(Collectors.toList()));
            if (!orgGroupByTerminalCodeList.isEmpty()) {
                collect.forEach(x -> x.setOrgList(orgGroupByTerminalCodeList.get(x.getTerminalCode())));
            }
        }
        return collect;
    }

    @Override
    public Long findPositionRelationTerminalCount(String positionCode) {
        if (StringUtils.isEmpty(positionCode)) {
            return 0L;
        }
        List<MdmPositionRespVo> position = mdmPositionService.findAllChildrenPositionList(null, positionCode);
        if (CollectionUtils.isEmpty(position)) {
            return 0L;
        }
        List<String> positionCodeList = position.stream()
                .map(MdmPositionRespVo::getPositionCode)
                .filter(code -> !StringUtils.isEmpty(code))
                .collect(Collectors.toList());

        List<String> collect = mdmTerminalSupplyService.findTerminalByPositionCodeList(positionCodeList);
        if (!collect.isEmpty()) {
            return (long) this.lambdaQuery()
                    .eq(MdmTerminalEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                    .in(MdmTerminalEntity::getTerminalCode, collect)
                    .list()
                    .size();
        }
        return 0L;

    }

    @Override
    public Long findPositionRelationTerminalCustomerCount(String positionCode) {
        if (StringUtils.isEmpty(positionCode)) {
            return 0L;
        }
        List<MdmPositionRespVo> position = mdmPositionService.findAllChildrenPositionList(null, positionCode);
        if (CollectionUtils.isEmpty(position)) {
            return 0L;
        }
        List<String> positionCodeList = position.stream()
                .map(MdmPositionRespVo::getPositionCode)
                .filter(code -> !StringUtils.isEmpty(code))
                .collect(Collectors.toList());
        Set<String> collect = mdmTerminalSupplyService.lambdaQuery()
                .in(MdmTerminalSupplyEntity::getPositionCode, positionCodeList)
                .select(MdmTerminalSupplyEntity::getTerminalCode)
                .list()
                .stream()
                .filter(x -> x != null && !StringUtils.isEmpty(x.getTerminalCode()))
                .map(MdmTerminalSupplyEntity::getTerminalCode)
                .collect(Collectors.toSet());
        if (!collect.isEmpty()) {
            return (long) this.lambdaQuery()
                    .eq(MdmTerminalEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                    .in(MdmTerminalEntity::getTerminalCode, collect)
                    .list()
                    .size();
        }
        return 0L;
    }

    @Override
    public MdmTerminalVo findDetailByRegisterOrName(String licenseRegisterNumber, String terminalName) {
        Assert.isTrue(!StringUtils.isEmpty(licenseRegisterNumber) || !StringUtils.isEmpty(terminalName), "营业注册号或终端名称不能为空");
        MdmTerminalVo mdmTerminalVo = mdmTerminalMapper.findDetailByRegisterOrName(licenseRegisterNumber, terminalName);
        log.info("终端信息:{},入参:{}", mdmTerminalVo, licenseRegisterNumber + ":" + terminalName);
        if (mdmTerminalVo == null) {
            return null;
        }
        String terminalCode = mdmTerminalVo.getTerminalCode();
        Assert.hasText(terminalCode, "终端编码不能为空");

        mdmTerminalVo.setContacts(mdmTerminalContactService.findByTerminalCode(terminalCode));
        mdmTerminalVo.setSupplys(mdmTerminalSupplyService.findByTerminalCode(terminalCode));
        setUpOrgName(Collections.singletonList(mdmTerminalVo));
        return mdmTerminalVo;
    }

    @Override
    public PageResult<MdmTerminalContactPageVo> distanceContactPage(MdmTerminalDistanceContactPageReqVo mdmTerminalDistanceContactPageReqVo) {
        Page<MdmTerminalContactPageVo> page = PageUtil.buildPage(mdmTerminalDistanceContactPageReqVo.getPageNum(), mdmTerminalDistanceContactPageReqVo.getPageSize());
        List<MdmTerminalContactPageVo> list = mdmTerminalMapper.distanceContactPage(page, mdmTerminalDistanceContactPageReqVo);
        return PageResult.<MdmTerminalContactPageVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public List<MdmTerminalSelectRespVo> findTerminalSelectList(MdmTerminalSelectReqVo reqVo) {
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue(ParameterParam.SELECT_BOX_OPTION_SIZE));
        }
        List<MdmTerminalSelectRespVo> list = new ArrayList<>(INITIAL_CAPACITY);
        Set<String> codeList = new HashSet<>(INITIAL_CAPACITY);
        if (StringUtils.isNotEmpty(reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList<>(codeList));
        }
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        if (pageSize > 0) {
            list.addAll(mdmTerminalMapper.findTerminalSelectList(new Page<>(1L, pageSize, false), reqVo, null, null));
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void submit(MdmTerminalVo reqVo) {
        Assert.hasText(reqVo.getId(), "id不能为空");
        Assert.hasText(reqVo.getWorkFlowKey(), "请选择流程");
        MdmTerminalEntity entity = this.getById(reqVo.getId());
        if (!ApprovalType.BPM.getValue().equals(entity.getApprovalType())) {
            throw new BusinessException("该条数据不能发起流程审批");
        }
        if (MdmBpmStatusEnum.PASS.getValue().equals(entity.getActApproveStatus())) {
            throw new BusinessException("审批通过的数据不能发起流程");
        }
        if (MdmBpmStatusEnum.APPROVAL.getValue().equals(entity.getActApproveStatus())) {
            throw new BusinessException("审批中的数据不能发起流程");
        }

        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("MdmTerminalCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setFormType(StringUtils.isNotEmpty(reqVo.getFromType()) ? reqVo.getFromType() : "MDM");
        startProcessReqVo.setCostType("terminal");
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(String.valueOf(System.currentTimeMillis()));
        startProcessReqVo.setBusinessCode(entity.getTerminalCode());
        startProcessReqVo.setFileList(reqVo.getActivityFileList());
        String processNo = ActivityUtils.startProcess(startProcessReqVo);
        entity.setProcessCode(processNo);
        entity.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void callback(ActivitiCallBackVo reqVo) {
        MdmTerminalEntity entity = this.getById(reqVo.getFormNo());
        boolean sendMq = false;
        //审批通过
        if (Indicator.CON_BPM_DOING.getCode() == reqVo.getProcessState()) {
            entity.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            sendMq = true;
        }
        //审批驳回
        if (Indicator.CON_BPM_PASS.getCode() == reqVo.getProcessState()) {
            entity.setActApproveStatus(MdmBpmStatusEnum.REJECT.getValue());
        }
        //流程追回
        if (Indicator.CON_BPM_REJECT.getCode() == reqVo.getProcessState()) {
            entity.setActApproveStatus(MdmBpmStatusEnum.RECOVER.getValue());
        }
        this.updateById(entity);
        if (sendMq) {
            sendChangeMsg(Collections.singletonList(entity.getTerminalCode()));
            sendAchievementMsg(entity.getTerminalCode(), entity.getFromType());
            MdmTerminalVo query = query(reqVo.getFormNo(), null);
            elasticsearchService.add(query);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void statusApprovalSubmit(List<String> ids) {
        Assert.notEmpty(ids, "空参数");
        List<MdmTerminalEntity> list = this.lambdaQuery()
                .in(MdmTerminalEntity::getId, ids)
                .list();
        Assert.notEmpty(list, "无效的id");
        list.forEach(x -> {
            Assert.isTrue(ApprovalType.STATUS.getValue().equals(x.getApprovalType()), "该数据不能提交状态审批");
            Assert.isTrue(!MdmBpmStatusEnum.APPROVAL.getValue().equals(x.getActApproveStatus()), "审批中的数据不能提交状态审批");
            Assert.isTrue(!MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus()), "审批通过的数据不能提交状态审批");
            x.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
        });
        this.updateBatchById(list);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void statusApprovalReject(List<String> ids) {
        Assert.notEmpty(ids, "空参数");
        List<MdmTerminalEntity> list = this.lambdaQuery()
                .in(MdmTerminalEntity::getId, ids)
                .list();
        Assert.notEmpty(list, "无效的id");
        list.forEach(x -> {
            Assert.isTrue(ApprovalType.STATUS.getValue().equals(x.getApprovalType()), "该数据不能提交状态审批");
            Assert.isTrue(MdmBpmStatusEnum.APPROVAL.getValue().equals(x.getActApproveStatus()), "审批中的数据才能驳回");
            x.setActApproveStatus(MdmBpmStatusEnum.REJECT.getValue());
        });
        this.updateBatchById(list);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void statusApprovalAgree(List<String> ids) {
        Assert.notEmpty(ids, "空参数");
        List<MdmTerminalEntity> list = this.lambdaQuery()
                .in(MdmTerminalEntity::getId, ids)
                .list();
        Assert.notEmpty(list, "无效的id");
        list.forEach(x -> {
            Assert.isTrue(ApprovalType.STATUS.getValue().equals(x.getApprovalType()), "该数据不能提交状态审批");
            Assert.isTrue(MdmBpmStatusEnum.APPROVAL.getValue().equals(x.getActApproveStatus()), "审批中的数据才能通过");
            x.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        });

        this.updateBatchById(list);
        this.sendInsertMsgForApprovalAgree(list);
    }

    /**
     * 审批通过，发送消息
     *
     * @param list
     */
    protected void sendInsertMsgForApprovalAgree(List<MdmTerminalEntity> list) {
        if (null == list) {
            return;
        }
        for (MdmTerminalEntity mdmTerminalEntity : list) {
            this.sendInsertMsg(JsonPropertyUtil.toJsonStringNotEmptyVal(mdmTerminalEntity));
        }
    }

    @Override
    public List<MdmTerminalSupplyVo> findTerminalSupply(MdmTerminalVo mdmTerminalVo) {
        if (CollectionUtils.isEmpty(mdmTerminalVo.getTerminalCodeList())) {
            return new ArrayList<>();
        }
        return mdmTerminalSupplyService.findTerminalSupply(mdmTerminalVo);
    }

    @Override
    public PageResult<MdmTerminalContactPageVo> findTerminalAndContactList(MdmTerminalCurrentAndSubVo mdmTerminalCurrentAndSubVo) {
        Page<MdmTerminalVo> page = PageUtil.buildPage(mdmTerminalCurrentAndSubVo.getPageNum(), mdmTerminalCurrentAndSubVo.getPageSize());
        String orgCode = mdmTerminalCurrentAndSubVo.getCurrentAndSubOrgCode();
        if (!StringUtils.isEmpty(orgCode)) {
            //查询当前及全部下级组织编码
            List<String> allOrgCodeList = OrgUtil.getChildrenOrgCodeListIncludeSelfEnable(orgCode);
            if (CollectionUtils.isEmpty(allOrgCodeList)) {
                return PageResult.empty();
            }
            mdmTerminalCurrentAndSubVo.setOrgCodeList(allOrgCodeList);
        }
        String positionCode = mdmTerminalCurrentAndSubVo.getPositionCode();
        if (!StringUtils.isEmpty(positionCode)) {
            List<String> currentAndSubPositionCodeList = PositionUtil.getChildrenPositionCodeListIncludeSelfEnable(positionCode);
            mdmTerminalCurrentAndSubVo.setPositionCodeList(currentAndSubPositionCodeList);
        }
        List<MdmTerminalContactPageVo> terminalAndContactList = mdmTerminalMapper.findTerminalAndContactList(page, mdmTerminalCurrentAndSubVo);
        return PageResult.<MdmTerminalContactPageVo>builder()
                .data(terminalAndContactList)
                .count(page.getTotal())
                .build();
    }

    private MdmTerminalVo queryById(MdmTerminalVo mdmTerminalVo) {
        MdmTerminalVo query = new MdmTerminalVo();
        query.setId(mdmTerminalVo.getId());
        List<MdmTerminalVo> mdmTerminalVos = this.listCondition(query);
        if (mdmTerminalVos.isEmpty()) {
            return new MdmTerminalVo();
        }
        return mdmTerminalVos.get(0);
    }

    private void setRegionName(MdmTerminalEntity entity) {
        if (StringUtils.isNotEmpty(entity.getProvinceCode()) || StringUtils.isNotEmpty(entity.getCityCode()) || StringUtils.isNotEmpty(entity.getDistrictCode())) {
            Set<String> regionCodeSet = new HashSet<>(INITIAL_CAPACITY);
            if (StringUtils.isNotEmpty(entity.getProvinceCode())) {
                regionCodeSet.add(entity.getProvinceCode());
            }
            if (StringUtils.isNotEmpty(entity.getCityCode())) {
                regionCodeSet.add(entity.getCityCode());
            }
            if (StringUtils.isNotEmpty(entity.getDistrictCode())) {
                regionCodeSet.add(entity.getDistrictCode());
            }
            MdmRegionService mdmRegionService = SpringApplicationContextUtil.getApplicationContext().getBean(MdmRegionService.class);
            Map<String, String> regionCodeNameMap = mdmRegionService.getRegionCodeNameMap(new ArrayList<>(regionCodeSet));
            entity.setProvinceName(regionCodeNameMap.get(entity.getProvinceCode()));
            entity.setCityName(regionCodeNameMap.get(entity.getCityCode()));
            entity.setDistrictName(regionCodeNameMap.get(entity.getDistrictCode()));
        }
    }

    @Override
    public List<MdmTerminalStatisticianTypeVo> statisticalType(MdmTerminalVo mdmTerminalVo) {
        List<MdmTerminalStatisticianTypeVo> statisticalType = mdmTerminalMapper.statisticalType(mdmTerminalVo);
        if (!CollectionUtils.isEmpty(statisticalType)) {
            Map<String, String> terminalType = DictUtil.dictMap("terminal_type");
            return statisticalType.stream()
                    .filter(x -> terminalType.containsKey(x.getStatisticianType()))
                    .peek(x -> {
                        x.setStatisticianName(terminalType.get(x.getStatisticianType()));
                    }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean checkTerminalCodeRelByOrgCodeList(List<String> orgCodeList, String terminalCode) {
        Map<String, List<String>> orgCodeGroupListMap = mdmTerminalROrgService.findOrgCodeList(Collections.singletonList(terminalCode));
        if (!orgCodeGroupListMap.isEmpty()) {
            List<String> strings = orgCodeGroupListMap.get(terminalCode);
            strings.retainAll(orgCodeList);
            if (!strings.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean checkTerminalCodeRelByCustomerCodeList(List<String> customerCodeList, String terminalCode) {
        List<String> list = mdmTerminalSupplyService.findCustomerCodeListByTerminalCode(terminalCode);
        if (list.size() > 0) {
            list.retainAll(customerCodeList);
            if (list.size() > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<String> checkTerminalCodeRelByOrgOrCusCode(SfaTpmOrgRCusVo orgRCusVo) {
        String terminalCode = orgRCusVo.getTerminalCode();
        List<SfaTpmOrgRCusVo.OrgRCus> orgRCusList = orgRCusVo.getOrgRCusList();
        List<String> ids = new ArrayList<>();
        orgRCusList.forEach(data -> {
            if (data.getCustomerCode() != null) {
                Boolean flag = checkTerminalCodeRelByCustomerCodeList(Lists.newArrayList(data.getCustomerCode()), terminalCode);
                if (flag) {
                    ids.add(data.getId());
                }
            } else if (data.getOrgCode() != null) {
                List<String> orgCodeList = OrgUtil.getChildrenOrgCodeListIncludeSelf(data.getOrgCode());
                Boolean flag = checkTerminalCodeRelByOrgCodeList(orgCodeList, terminalCode);
                if (flag) {
                    ids.add(data.getId());
                }
            }
        });
        return ids;
    }

    @Override
    public List<MdmTerminalVo> findTerminalByCustomerOrgCodeList(List<String> customerOrgCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(customerOrgCodeList)) {
            List<String> list = CustomerOrgUtil.getChildrenCustomerOrgCodeListIncludeSelfEnable(customerOrgCodeList.stream().filter(x -> StringUtils.isNotEmpty(x)).distinct().collect(Collectors.toList()));
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                List<MdmTerminalEntity> entityList = this.lambdaQuery()
                        .eq(MdmTerminalEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                        .eq(MdmTerminalEntity::getActApproveStatus, MdmBpmStatusEnum.PASS.getValue())
                        .in(MdmTerminalEntity::getCustomerOrgCode, list)
                        .list();
                if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                    return CrmBeanUtil.copyList(entityList, MdmTerminalVo.class);
                }
            }
        }
        return new ArrayList<>();
    }

    @Override
    public MdmTerminalVo findTerminalByNameOrAddress(String terminalName, String terminalAddress) {
        Assert.isTrue(!StringUtils.isEmpty(terminalName) || !StringUtils.isEmpty(terminalAddress), "终端名称或终端地址不能为空");
        MdmTerminalVo mdmTerminalVo = mdmTerminalMapper.findTerminalByNameOrAddress(terminalName, terminalAddress);
        log.info("终端信息:{},入参:{}", mdmTerminalVo, terminalName + ":" + terminalAddress);
        if (mdmTerminalVo == null) {
            return null;
        }
        String terminalCode = mdmTerminalVo.getTerminalCode();
        Assert.hasText(terminalCode, "终端编码不能为空");

        mdmTerminalVo.setContacts(mdmTerminalContactService.findByTerminalCode(terminalCode));
        mdmTerminalVo.setSupplys(mdmTerminalSupplyService.findByTerminalCode(terminalCode));
        setUpOrgName(Collections.singletonList(mdmTerminalVo));
        return mdmTerminalVo;
    }

  @Override
  public List<MdmTerminalVo> queryTerminalAndAttachByCode(List<String> terminalCodeList) {
      if(CollectionUtil.listEmpty(terminalCodeList)){
        return new ArrayList<>();
      }
      List<MdmTerminalVo> mdmTerminalVolist = lambdaQuery()
        .in(MdmTerminalEntity::getTerminalCode, terminalCodeList)
        .list()
        .stream().map(x -> CrmBeanUtil.copy(x, MdmTerminalVo.class)).collect(Collectors.toList());
      if(CollectionUtil.listNotEmpty(mdmTerminalVolist)){
          MdmDictDataReqVo reqVo = new MdmDictDataReqVo();
          reqVo.setDictTypeCode("channel");
          List<MdmDictDataRespVo> list = mdmDictDataMapper.findList(null, reqVo);
          mdmTerminalVolist.forEach(item->{
          item.setContacts(mdmTerminalContactService.findByTerminalCode(item.getTerminalCode()));
          item.setSupplys(mdmTerminalSupplyService.findByTerminalCode(item.getTerminalCode()));
          if (StringUtils.isNotEmpty(item.getOrgCode())){
              item.setOrgName(mdmOrgService.lambdaQuery().eq(MdmOrgEntity::getOrgCode,item.getOrgCode()).one().getOrgName());
          }
          if (StringUtils.isNotEmpty(item.getCustomerOrgCode())){
              item.setCustomerOrgName(mdmCusOrgService.lambdaQuery().eq(MdmCusOrgEntity::getCustomerOrgCode,item.getCustomerOrgCode()).one().getCustomerOrgName());
          }
          if (CollectionUtil.listNotEmptyNotSizeZero(list)){
              list.forEach(x ->
              {
                  if (x.getDictCode().equals(item.getChannel())) {
                      item.setChannelName(x.getDictValue());
                  }
              });
          }
        });
      }
    return mdmTerminalVolist;
  }

    /**
     * 终端信息变更发送事件
     *
     * @param vo
     */
    private void terminalChangeSendEvent(TerminalChangeHandlerReqVo vo) {
        applicationContext.publishEvent(new TerminalChangeEvent(vo));
    }

    @Override
    public List<MdmTerminalVo> queryTerminalByOrgCodeList(SfaTPMTerminalReqVo reqVo) {
        List<MdmTerminalVo> mdmTerminalVos = mdmTerminalMapper.selectTerminalByOrgCodeList(reqVo);
        return mdmTerminalVos;
    }

}





