package com.biz.crm.terminal.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalSupplyDetailVo;
import com.biz.crm.terminal.mapper.MdmTerminalSupplyDetailMapper;
import com.biz.crm.terminal.model.MdmTerminalSupplyDetailEntity;
import com.biz.crm.terminal.service.MdmTerminalSupplyDetailService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 终端图片接口实现
 *
 * @author zxw
 * @date 2020-11-23 11:53:06
 */
@Slf4j
@Service
@Transactional
@ConditionalOnMissingBean(name = "mdmTerminalSupplyDetailServiceExpandImpl")
public class MdmTerminalSupplyDetailServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmTerminalSupplyDetailMapper, MdmTerminalSupplyDetailEntity> implements MdmTerminalSupplyDetailService {

    @Override
    public List<MdmTerminalSupplyDetailEntity> getListBySupplyIdOrDataType(List<String> supplyIds, String dataType) {
        if (CollectionUtils.isEmpty(supplyIds)) {
            return new ArrayList<>();
        }
        QueryWrapper<MdmTerminalSupplyDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("supply_id", supplyIds);
        if (StringUtils.isNotEmpty(dataType)) {
            queryWrapper.eq("data_type", dataType);
        }
        List<MdmTerminalSupplyDetailEntity> list = this.list(queryWrapper);
        list = list == null ? new ArrayList<>() : list;
        return list;
    }

    @Override
    public void saveList(List<MdmTerminalSupplyDetailVo> details) {
        if (CollectionUtil.listEmpty(details)) {
            return;
        }
        List<MdmTerminalSupplyDetailEntity> entities = CrmBeanUtil.copyList(details, MdmTerminalSupplyDetailEntity.class);
        entities.forEach(x->{
            x.setId(UUID.randomUUID().toString());
        });
        this.saveBatch(entities);
    }

    @Override
    public void updateList(List<MdmTerminalSupplyDetailVo> details, String supplyId) {
        if (StringUtils.isEmpty(supplyId)) {
            throw new BusinessException("供货关联关系不能为空");
        }
        if (CollectionUtil.listEmpty(details)) {
            //全部删除
            QueryWrapper<MdmTerminalSupplyDetailEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("supply_id", supplyId);
            this.remove(queryWrapper);
            return;
        }
        details.forEach(item -> {
            item.setSupplyId(supplyId);
        });
        QueryWrapper<MdmTerminalSupplyDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("supply_id", supplyId);
        List<MdmTerminalSupplyDetailEntity> oldList = this.list(queryWrapper);
        List<MdmTerminalSupplyDetailVo> addList = new ArrayList<>();
        List<MdmTerminalSupplyDetailVo> updateList = new ArrayList<>();
        List<MdmTerminalSupplyDetailEntity> deleteList = new ArrayList<>();
        Map<String, MdmTerminalSupplyDetailEntity> itemMap = oldList.stream().collect(Collectors.toMap(MdmTerminalSupplyDetailEntity::getId, item -> item));
        itemMap = itemMap == null ? new HashMap<>() : itemMap;
        for (MdmTerminalSupplyDetailVo item : details) {
            if (itemMap.containsKey(item.getId())) {
                updateList.add(item);
                itemMap.remove(item.getId());
            } else {
                addList.add(item);
            }
        }
        if (!itemMap.isEmpty()) {
            for (Map.Entry<String, MdmTerminalSupplyDetailEntity> mapItem : itemMap.entrySet()) {
                deleteList.add(mapItem.getValue());
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            List<MdmTerminalSupplyDetailEntity> entities = CrmBeanUtil.copyList(addList, MdmTerminalSupplyDetailEntity.class);
            for (MdmTerminalSupplyDetailEntity entity : entities) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.saveBatch(entities);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(updateList)) {
            List<MdmTerminalSupplyDetailEntity> updateEntitys = CrmBeanUtil.copyList(updateList, MdmTerminalSupplyDetailEntity.class);
            this.updateBatchById(updateEntitys);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteList)) {
            List<String> ids = deleteList.stream().map(MdmTerminalSupplyDetailEntity::getId).collect(Collectors.toList());
            this.removeByIds(ids);
        }
    }

    @Override
    public void deleteBySupplyIds(List<String> supplyIds) {
        if (CollectionUtil.listEmpty(supplyIds)) {
            return;
        }
        QueryWrapper<MdmTerminalSupplyDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("supply_id", supplyIds);
        this.remove(queryWrapper);
    }
}
