package com.biz.crm.user.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.param.ParameterParam;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalDetailRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmTerminalUserEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmTerminalUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmTerminalUserTerminalSelectReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserForceChangePasswordReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmTerminalUserControlControlRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmTerminalUserDetailRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmTerminalUserPageRespVo;
import com.biz.crm.user.service.MdmTerminalUserService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@Slf4j
@RestController
@RequestMapping("/mdmTerminalUserController")
@CrmGlobalLog
@Api(tags = "MDM-用户管理（终端用户）")
public class MdmTerminalUserController {

    @Autowired
    private MdmTerminalUserService mdmTerminalUserService;
    @Autowired
    private MdmUserService mdmUserService;


    @ApiOperation(value = "查询分页列表")
    @PostMapping("/pageList")
    @CrmDictMethod
    public Result<PageResult<MdmTerminalUserPageRespVo>> pageList(@RequestBody MdmTerminalUserPageReqVo reqVo) {
        PageResult<MdmTerminalUserPageRespVo> result = mdmTerminalUserService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result save(@RequestBody MdmTerminalUserEditReqVo reqVo) {
        mdmTerminalUserService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value = "终端用户详情-根据ID查询", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query")})
    @GetMapping("/detailById")
    @CrmDictMethod
    public Result<MdmTerminalUserDetailRespVo> queryById(@RequestParam(value = "id", required = true) String id) {
        return Result.ok(mdmTerminalUserService.queryByIdOrUsername(id,null));
    }


    @ApiOperation(value = "终端用户详情-根据用户登录名查询", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "userName", value = "用户登录名", required = false, dataType = "String", paramType = "query")})
    @GetMapping("/detailByUsername")
    @CrmDictMethod
    public Result<MdmTerminalUserDetailRespVo> queryByName(@RequestParam(value = "userName", required = true) String userName) {
        return Result.ok(mdmTerminalUserService.queryByIdOrUsername(null,userName));
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result update(@RequestBody MdmTerminalUserEditReqVo reqVo) {
        mdmTerminalUserService.update(reqVo);
        return Result.ok("修改成功");
    }

    @ApiOperation(value = "删除", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")})
    @PostMapping("/delete")
    public Result delete(@RequestBody List<String> ids) {
        mdmTerminalUserService.deleteBatch(ids);
        return Result.ok("删除成功");
    }


    @ApiOperation(value = "启用", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")})
    @PostMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        mdmUserService.enableBatch(ids);
        return Result.ok("启用成功");
    }


    @ApiOperation(value = "禁用", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")})
    @PostMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        mdmUserService.disableBatch(ids);
        return Result.ok("禁用成功");
    }


    @ApiOperation(value = "用户解锁", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")})
    @PostMapping("/unlock")
    public Result unlock(@RequestBody List<String> ids) {
        mdmUserService.unlock(ids);
        return Result.ok("解锁成功");
    }



    @ApiOperation(value = "强制批量修改密码", httpMethod = "POST")
    @PostMapping("/forceChangePassword")
    public Result forceChangePassword(@RequestBody MdmUserForceChangePasswordReqVo reqVo) {
        mdmUserService.forceChangePassword(reqVo);
        return Result.ok("修改成功");
    }


    /**
     * 获取终端下拉列表，如果是新增，那么需要返回没有被用户关联的终端
     * 如果是编辑，前端需要将当前编辑的用户名传过来，然后将当前用户已经关联的终端放在前面
     * @return 满足特定条件的终端列表
     */
    @ApiOperation(value = "新增/编辑终端下拉列表", httpMethod = "POST", notes = "新增:返回所有未被关联的终端；编辑:返回当前用户已经关联的终端和未被其他用户关联的终端")
    @PostMapping("/getTerminalListByCondition")
    public Result<List<MdmTerminalDetailRespVo>> getTerminalListByCondition(@RequestBody MdmTerminalUserTerminalSelectReqVo reqVo) {
        return Result.ok(mdmTerminalUserService.getTerminalListByCondition(reqVo));
    }


    @ApiOperation(value = "获取终端用户新增编辑页面控制变量")
    @GetMapping("/getTerminalUserControl")
    public Result<MdmTerminalUserControlControlRespVo> getTerminalUserControl() {
        MdmTerminalUserControlControlRespVo respVo = new MdmTerminalUserControlControlRespVo();
        respVo.setUserCanRelationManyTerminal(ParamUtil.getParameterValue(ParameterParam.USER_CAN_RELATION_MANY_TERMINAL));
        return Result.ok(respVo);
    }

}
